/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.List;
import javax.script.Bindings;
import org.forgerock.openam.scripting.ScriptError;
import org.forgerock.openam.scripting.ScriptingLanguage;
import org.forgerock.util.Reject;

public final class ScriptObject {
    private final String name;
    private final String script;
    private final ScriptingLanguage language;
    private final Bindings bindings;

    public ScriptObject(String name, String script, ScriptingLanguage language, Bindings bindings) {
        Reject.ifNull((Object[])new Object[]{name, script, language});
        this.name = name;
        this.script = script;
        this.language = language;
        this.bindings = bindings;
    }

    public ScriptObject(String name, String script, ScriptingLanguage language) {
        this(name, script, language, null);
    }

    public String getName() {
        return this.name;
    }

    public String getScript() {
        return this.script;
    }

    public ScriptingLanguage getLanguage() {
        return this.language;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptObject)) {
            return false;
        }
        ScriptObject that = (ScriptObject)o;
        if (this.bindings != null) {
            if (!this.bindings.equals(that.getBindings())) {
                return false;
            }
        } else if (that.getBindings() != null) return false;
        if (!this.language.equals(that.getLanguage())) return false;
        if (!this.name.equals(that.getName())) return false;
        if (!this.script.equals(that.getScript())) return false;
        return true;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.script.hashCode();
        result = 31 * result + this.language.hashCode();
        result = 31 * result + (this.bindings != null ? this.bindings.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScriptObject{name='" + this.name + '\'' + ", language=" + this.language + ", bindings=" + this.bindings + '}';
    }

    public List<ScriptError> validate() {
        return this.language.getScriptValidator().validateScript(this);
    }
}

