/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.forgerock.openam.scripting.ScriptError;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.ScriptValidator;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.util.Reject;
import org.mozilla.javascript.EvaluatorException;

public class StandardScriptValidator
implements ScriptValidator {
    private final ScriptEngineManager scriptEngineManager;

    @Inject
    public StandardScriptValidator(StandardScriptEngineManager scriptEngineManager) {
        Reject.ifNull((Object)scriptEngineManager);
        this.scriptEngineManager = scriptEngineManager;
    }

    @Override
    public List<ScriptError> validateScript(ScriptObject script) {
        Reject.ifNull((Object)script);
        ScriptEngine scriptEngine = script.getLanguage().getScriptEngine(this.scriptEngineManager);
        ArrayList<ScriptError> scriptErrorList = new ArrayList<ScriptError>();
        if (scriptEngine instanceof Compilable) {
            try {
                ((Compilable)((Object)scriptEngine)).compile(script.getScript());
            }
            catch (ScriptException se) {
                scriptErrorList.addAll(this.getScriptErrors(script, se));
            }
        }
        return scriptErrorList;
    }

    private List<ScriptError> getScriptErrors(ScriptObject script, ScriptException se) {
        ArrayList<ScriptError> scriptErrorList = new ArrayList<ScriptError>();
        Throwable cause = se.getCause();
        if (cause instanceof EvaluatorException) {
            EvaluatorException ee = (EvaluatorException)cause;
            ScriptError error = new ScriptError();
            error.setScriptName(script.getName());
            error.setMessage(ee.details());
            error.setLineNumber(ee.lineNumber());
            error.setColumnNumber(ee.columnNumber());
            scriptErrorList.add(error);
        } else if (cause instanceof MultipleCompilationErrorsException) {
            ErrorCollector errorCollector = ((MultipleCompilationErrorsException)cause).getErrorCollector();
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                SyntaxException syntaxException = errorCollector.getSyntaxError(i);
                ScriptError error = new ScriptError();
                error.setScriptName(script.getName());
                error.setMessage(syntaxException.getOriginalMessage());
                error.setLineNumber(syntaxException.getLine());
                error.setColumnNumber(syntaxException.getStartColumn());
                scriptErrorList.add(error);
            }
        } else {
            ScriptError error = new ScriptError();
            error.setScriptName(script.getName());
            error.setMessage(se.getMessage());
            error.setLineNumber(se.getLineNumber());
            error.setColumnNumber(se.getColumnNumber());
            scriptErrorList.add(error);
        }
        return scriptErrorList;
    }
}

