/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.datastore;

import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

public class ScriptingQueryFilterVisitor
implements QueryFilterVisitor<Set<String>, Map<String, Map<String, Set<String>>>, JsonPointer> {
    public Set<String> visitAndFilter(Map<String, Map<String, Set<String>>> resourceData, List<QueryFilter<JsonPointer>> subFilters) {
        HashSet<String> andResults = new HashSet<String>();
        boolean firstFilter = true;
        for (QueryFilter<JsonPointer> filter : subFilters) {
            Set result = (Set)filter.accept((QueryFilterVisitor)this, resourceData);
            if (firstFilter) {
                andResults.addAll(result);
                firstFilter = false;
                continue;
            }
            andResults.retainAll(result);
        }
        return andResults;
    }

    public Set<String> visitOrFilter(Map<String, Map<String, Set<String>>> resourceData, List<QueryFilter<JsonPointer>> subFilters) {
        HashSet<String> orResults = new HashSet<String>();
        for (QueryFilter<JsonPointer> filter : subFilters) {
            orResults.addAll((Collection)filter.accept((QueryFilterVisitor)this, resourceData));
        }
        return orResults;
    }

    public Set<String> visitEqualsFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        this.assertFieldDepth(field, 1);
        HashSet<String> equalsResults = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : resourceData.entrySet()) {
            if (!valueAssertion.equals(CollectionHelper.getMapAttr(entry.getValue(), (String)field.get(0)))) continue;
            equalsResults.add(entry.getKey());
        }
        return equalsResults;
    }

    public Set<String> visitContainsFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        this.assertFieldDepth(field, 1);
        HashSet<String> containsResults = new HashSet<String>();
        if (valueAssertion instanceof String) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : resourceData.entrySet()) {
                String value = CollectionHelper.getMapAttr(entry.getValue(), (String)field.get(0));
                if (!StringUtils.isNotEmpty((String)value) || !value.contains((String)valueAssertion)) continue;
                containsResults.add(entry.getKey());
            }
        }
        return containsResults;
    }

    public Set<String> visitStartsWithFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        this.assertFieldDepth(field, 1);
        HashSet<String> containsResults = new HashSet<String>();
        if (valueAssertion instanceof String) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : resourceData.entrySet()) {
                String value = CollectionHelper.getMapAttr(entry.getValue(), (String)field.get(0));
                if (!StringUtils.isNotEmpty((String)value) || !value.startsWith((String)valueAssertion)) continue;
                containsResults.add(entry.getKey());
            }
        }
        return containsResults;
    }

    private void assertFieldDepth(JsonPointer field, int depth) {
        if (field.size() > depth) {
            throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.RESOURCE_FILTER_NOT_SUPPORTED.name());
        }
    }

    public Set<String> visitBooleanLiteralFilter(Map<String, Map<String, Set<String>>> resourceData, boolean value) {
        if (value) {
            return resourceData.keySet();
        }
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_BOOLEAN_LITERAL_FALSE.name());
    }

    public Set<String> visitExtendedMatchFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, String operator, Object valueAssertion) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_EXTENDED_MATCH.name());
    }

    public Set<String> visitGreaterThanFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_GREATER_THAN.name());
    }

    public Set<String> visitGreaterThanOrEqualToFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_GREATER_THAN_OR_EQUAL.name());
    }

    public Set<String> visitLessThanFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_LESS_THAN.name());
    }

    public Set<String> visitLessThanOrEqualToFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field, Object valueAssertion) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_LESS_THAN_OR_EQUAL.name());
    }

    public Set<String> visitNotFilter(Map<String, Map<String, Set<String>>> resourceData, QueryFilter<JsonPointer> subFilter) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_NOT.name());
    }

    public Set<String> visitPresentFilter(Map<String, Map<String, Set<String>>> resourceData, JsonPointer field) {
        throw new UnsupportedOperationException(ScriptConstants.ScriptErrorCode.FILTER_PRESENT.name());
    }
}

