/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import groovy.lang.GroovyClassLoader;
import groovy.transform.ThreadInterrupt;
import javax.script.ScriptEngine;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineFactory;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.forgerock.openam.scripting.factories.SandboxedGroovyScriptEngine;
import org.forgerock.util.Reject;
import org.kohsuke.groovy.sandbox.GroovyValueFilter;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class GroovyEngineFactory
extends GroovyScriptEngineFactory {
    private volatile GroovyValueFilter sandbox;
    private final GroovyScriptEngineImpl groovyScriptEngine;

    public GroovyEngineFactory() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(ThreadInterrupt.class)});
        GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), compilerConfig);
        this.groovyScriptEngine = new GroovyScriptEngineImpl(classLoader);
    }

    public ScriptEngine getScriptEngine() {
        return new SandboxedGroovyScriptEngine(this, (ScriptEngine)this.groovyScriptEngine, this.sandbox);
    }

    public void setSandbox(GroovyValueFilter sandbox) {
        Reject.ifNull((Object)sandbox);
        this.sandbox = sandbox;
    }
}

