/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.forgerock.openam.scripting.factories.RhinoScriptEngine;
import org.forgerock.util.Reject;
import org.mozilla.javascript.Script;

final class RhinoCompiledScript
extends CompiledScript {
    private final RhinoScriptEngine engine;
    private final Script compiledScript;

    RhinoCompiledScript(RhinoScriptEngine engine, Script compiledScript) {
        Reject.ifNull((Object[])new Object[]{engine, compiledScript});
        this.engine = engine;
        this.compiledScript = compiledScript;
    }

    @Override
    public Object eval(ScriptContext scriptContext) throws ScriptException {
        return this.engine.evalCompiled(this.compiledScript, scriptContext);
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RhinoCompiledScript that = (RhinoCompiledScript)o;
        return this.compiledScript.equals(that.compiledScript) && this.engine.equals(that.engine);
    }

    public int hashCode() {
        int result = this.engine.hashCode();
        result = 31 * result + this.compiledScript.hashCode();
        return result;
    }

    public String toString() {
        return "RhinoCompiledScript{engine=" + this.engine + ", compiledScript=" + this.compiledScript + '}';
    }
}

