/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.forgerock.openam.scripting.factories.RhinoCompiledScript;
import org.forgerock.openam.scripting.factories.RhinoScriptEngineFactory;
import org.forgerock.openam.scripting.factories.ScriptContextScope;
import org.forgerock.util.Reject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class RhinoScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final RhinoScriptEngineFactory factory;

    RhinoScriptEngine(RhinoScriptEngineFactory factory) {
        Reject.ifNull((Object)factory);
        this.factory = factory;
    }

    @Override
    public Object eval(String source, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(source), scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Reject.ifNull((Object[])new Object[]{reader, scriptContext});
        Object result = null;
        Context context = this.factory.getContext();
        try {
            Scriptable scope = this.getScope(context, scriptContext);
            String filename = this.getFilename(scriptContext);
            result = context.evaluateReader(scope, reader, filename, 1, null);
        }
        catch (RhinoException ex) {
            throw this.convertException(ex);
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
        finally {
            this.factory.releaseContext(context);
        }
        return result;
    }

    Object evalCompiled(Script compiledScript, ScriptContext scriptContext) throws ScriptException {
        Reject.ifNull((Object[])new Object[]{compiledScript, scriptContext});
        Object result = null;
        Context context = this.factory.getContext();
        try {
            Scriptable scope = this.getScope(context, scriptContext);
            result = compiledScript.exec(context, scope);
        }
        catch (RhinoException ex) {
            throw this.convertException(ex);
        }
        finally {
            this.factory.releaseContext(context);
        }
        return result;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public RhinoScriptEngineFactory getFactory() {
        return this.factory;
    }

    private String getFilename(ScriptContext scriptContext) {
        Bindings engineBindings;
        String filename = null;
        if (scriptContext != null && (engineBindings = scriptContext.getBindings(100)) != null) {
            filename = (String)engineBindings.get("javax.script.filename");
        }
        if (filename == null) {
            filename = (String)this.get("javax.script.filename");
        }
        if (filename == null) {
            filename = "<Unknown source>";
        }
        return filename;
    }

    @Override
    public CompiledScript compile(String source) throws ScriptException {
        return this.compile(new StringReader(source));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        Reject.ifNull((Object)reader);
        Context context = this.factory.getContext();
        try {
            String filename = this.getFilename(this.getContext());
            Script compiledScript = context.compileReader(reader, filename, 1, null);
            RhinoCompiledScript rhinoCompiledScript = new RhinoCompiledScript(this, compiledScript);
            return rhinoCompiledScript;
        }
        catch (RhinoException ex) {
            throw this.convertException(ex);
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
        finally {
            this.factory.releaseContext(context);
        }
    }

    private Scriptable getScope(Context context, ScriptContext scriptContext) {
        ScriptContextScope scope = new ScriptContextScope(scriptContext);
        ScriptableObject topLevel = context.initStandardObjects();
        scope.setPrototype((Scriptable)topLevel);
        scope.put("context", scope, scriptContext);
        return scope;
    }

    private ScriptException convertException(RhinoException ex) {
        ScriptException se = new ScriptException(ex.getMessage(), ex.sourceName(), ex.lineNumber(), ex.columnNumber());
        se.initCause(ex);
        return se;
    }

    public String toString() {
        return "RhinoScriptEngine{factory=" + this.factory + '}';
    }
}

