/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import java.util.ArrayList;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.forgerock.util.Reject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

final class ScriptContextScope
implements Scriptable {
    private static final int SCOPE_NOT_FOUND = -1;
    private final ScriptContext scriptContext;
    private Scriptable prototype;
    private Scriptable parentScope;

    ScriptContextScope(ScriptContext scriptContext) {
        Reject.ifNull((Object)scriptContext);
        this.scriptContext = scriptContext;
    }

    public String getClassName() {
        return "ScriptContextScope";
    }

    public boolean has(String name, Scriptable start) {
        return this.scriptContext.getAttributesScope(name) != -1;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public Object get(String name, Scriptable start) {
        int scope = this.scriptContext.getAttributesScope(name);
        if (scope != -1) {
            Object result = this.scriptContext.getAttribute(name, scope);
            return Context.javaToJS((Object)result, (Scriptable)this);
        }
        return NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    public void put(String name, Scriptable start, Object value) {
        int scope = this.scriptContext.getAttributesScope(name);
        if (scope == -1) {
            scope = 100;
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        this.scriptContext.setAttribute(name, value, scope);
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
        int scope = this.scriptContext.getAttributesScope(name);
        if (scope != -1) {
            this.scriptContext.removeAttribute(name, scope);
        }
    }

    public void delete(int index) {
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        ArrayList keys = new ArrayList();
        for (int scope : this.scriptContext.getScopes()) {
            Bindings bindings = this.scriptContext.getBindings(scope);
            keys.addAll(bindings.keySet());
        }
        return keys.toArray();
    }

    public Object getDefaultValue(Class<?> hint) {
        return NativeObject.getDefaultValue((Scriptable)this, hint);
    }

    public boolean hasInstance(Scriptable instance) {
        for (Scriptable prototype = instance.getPrototype(); prototype != null; prototype = prototype.getPrototype()) {
            if (!prototype.equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptContextScope that = (ScriptContextScope)o;
        if (this.parentScope != null ? !this.parentScope.equals(that.parentScope) : that.parentScope != null) {
            return false;
        }
        if (this.prototype != null ? !this.prototype.equals(that.prototype) : that.prototype != null) {
            return false;
        }
        return this.scriptContext.equals(that.scriptContext);
    }

    public int hashCode() {
        int result = this.scriptContext.hashCode();
        result = 31 * result + (this.prototype != null ? this.prototype.hashCode() : 0);
        result = 31 * result + (this.parentScope != null ? this.parentScope.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScriptContextScope{scriptContext=" + this.scriptContext + ", prototype=" + this.prototype + ", parentScope=" + this.parentScope + '}';
    }
}

