/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.rest.batch.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.openam.utils.JsonArray;
import org.forgerock.openam.utils.JsonValueBuilder;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class Requester {
    private final Provider<Router> router;

    @Inject
    public Requester(@Named(value="CrestRootRouter") Provider<Router> router) {
        this.router = router;
    }

    public JsonValue create(String location, String resourceId, JsonValue payload, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Reject.ifNull((Object)payload, (String)"The payload object to create must not be null.");
        Router rootRouter = (Router)this.router.get();
        CreateRequest createRequest = Requests.newCreateRequest((String)location, (JsonValue)payload);
        if (resourceId != null) {
            createRequest.setNewResourceId(resourceId);
        }
        return ((ResourceResponse)rootRouter.handleCreate(context, createRequest).getOrThrowUninterruptibly()).getContent();
    }

    public JsonValue read(String location, String resourceId, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)resourceId), (String)"The resourceId to read may not be null or empty.");
        Router rootRouter = (Router)this.router.get();
        ReadRequest readRequest = Requests.newReadRequest((String)location, (String)resourceId);
        return ((ResourceResponse)rootRouter.handleRead(context, readRequest).getOrThrowUninterruptibly()).getContent();
    }

    public JsonValue update(String location, String resourceId, JsonValue payload, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)resourceId), (String)"The resourceId to update may not be null or empty.");
        Reject.ifNull((Object)payload, (String)"The payload object to create must not be null.");
        Router rootRouter = (Router)this.router.get();
        UpdateRequest updateRequest = Requests.newUpdateRequest((String)location, (String)resourceId, (JsonValue)payload);
        return ((ResourceResponse)rootRouter.handleUpdate(context, updateRequest).getOrThrowUninterruptibly()).getContent();
    }

    public JsonValue delete(String location, String resourceId, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)resourceId), (String)"The resourceId to delete may not be null or empty.");
        Router rootRouter = (Router)this.router.get();
        DeleteRequest deleteRequest = Requests.newDeleteRequest((String)location, (String)resourceId);
        return ((ResourceResponse)rootRouter.handleDelete(context, deleteRequest).getOrThrowUninterruptibly()).getContent();
    }

    public JsonValue action(String location, String resourceId, String actionId, JsonValue payload, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)actionId), (String)"The specific action to perform may not be null or empty.");
        Router rootRouter = (Router)this.router.get();
        ActionRequest actionRequest = Requests.newActionRequest((String)location, (String)actionId);
        if (payload != null) {
            actionRequest.setContent(payload);
        }
        if (resourceId != null) {
            actionRequest.setResourcePath(resourceId);
        }
        return ((ActionResponse)rootRouter.handleAction(context, actionRequest).getOrThrowUninterruptibly()).getJsonContent();
    }

    public JsonValue query(String location, String queryId, Context context) throws ResourceException {
        Reject.ifTrue((boolean)StringUtils.isEmpty((String)location), (String)"The endpoint destination may not be null or empty.");
        Router rootRouter = (Router)this.router.get();
        QueryRequest queryRequest = Requests.newQueryRequest((String)location);
        if (queryId != null) {
            queryRequest.setQueryId(queryId);
        }
        final InMemoryQueryResourceHandler resourceHandler = new InMemoryQueryResourceHandler();
        return (JsonValue)rootRouter.handleQuery(context, queryRequest, (QueryResourceHandler)resourceHandler).thenAsync((AsyncFunction)new AsyncFunction<QueryResponse, JsonValue, ResourceException>(){

            public Promise<JsonValue, ResourceException> apply(QueryResponse value) {
                JsonArray responses = JsonValueBuilder.jsonValue().array("results");
                for (ResourceResponse resource : resourceHandler.getResources()) {
                    responses.add((Object)resource.getContent());
                }
                return Promises.newResultPromise((Object)responses.build().build());
            }
        }).getOrThrowUninterruptibly();
    }

    private static final class InMemoryQueryResourceHandler
    implements QueryResourceHandler {
        private final List<ResourceResponse> resources = new ArrayList<ResourceResponse>();

        private InMemoryQueryResourceHandler() {
        }

        public boolean handleResource(ResourceResponse resource) {
            this.resources.add(resource);
            return true;
        }

        Collection<ResourceResponse> getResources() {
            return this.resources;
        }
    }
}

