/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.sandbox;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.lang.reflect.Method;
import org.forgerock.util.Reject;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.GroovyValueFilter;
import org.mozilla.javascript.ClassShutter;

public final class GroovySandboxValueFilter
extends GroovyValueFilter {
    private static final String ERROR_MESSAGE = "Access to Java class \"%s\" is prohibited.";
    private static final String CLOSURE_CALL_METHOD = "call";
    private final ClassShutter classShutter;

    public GroovySandboxValueFilter(ClassShutter classShutter) {
        Reject.ifNull((Object)classShutter);
        this.classShutter = classShutter;
    }

    public Object filter(Object target) {
        String className;
        Class<?> clazz;
        if (target == null) {
            return null;
        }
        if (target instanceof Closure) {
            return target;
        }
        Class<?> clazz2 = clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (this.classShutter.visibleToScripts(className = clazz.getName())) {
            return target;
        }
        throw new SecurityException(String.format(ERROR_MESSAGE, className));
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        if (receiver instanceof Script || receiver instanceof Closure) {
            return this.filterReturnValue(invoker.call(receiver, property));
        }
        return super.onGetProperty(invoker, receiver, property);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        if (receiver instanceof Script || receiver instanceof Closure) {
            return this.filterReturnValue(invoker.call(receiver, property, value));
        }
        return super.onSetProperty(invoker, receiver, property, value);
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        if (this.isClosureCall(receiver, method) || this.isScriptOwnMethodCall(receiver, method)) {
            return this.doCall(invoker, receiver, method, args);
        }
        return super.onMethodCall(invoker, receiver, method, args);
    }

    private boolean isClosureCall(Object receiver, String method) {
        return receiver instanceof Closure && CLOSURE_CALL_METHOD.equals(method);
    }

    private boolean isScriptOwnMethodCall(Object receiver, String method) {
        Method[] scriptOwnMethods;
        if (!(receiver instanceof Script)) {
            return false;
        }
        for (Method declaredMethod : scriptOwnMethods = receiver.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(method)) continue;
            return true;
        }
        return false;
    }

    private Object doCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        return this.filterReturnValue(invoker.call(receiver, method, this.filterArgs(args)));
    }

    private Object[] filterArgs(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.filterArgument(args[i]);
        }
        return args;
    }
}

