/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.sandbox;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.forgerock.util.Reject;
import org.mozilla.javascript.ClassShutter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RhinoSandboxClassShutter
implements ClassShutter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RhinoSandboxClassShutter.class);
    private final SecurityManager securityManager;
    private final List<Pattern> whiteList;
    private final List<Pattern> blackList;

    public RhinoSandboxClassShutter(SecurityManager securityManager, List<Pattern> whiteList, List<Pattern> blackList) {
        Reject.ifNull((Object[])new List[]{whiteList, blackList});
        this.securityManager = securityManager;
        this.whiteList = new ArrayList<Pattern>(whiteList);
        this.blackList = new ArrayList<Pattern>(blackList);
    }

    public boolean visibleToScripts(String fullClassName) {
        LOGGER.debug("Checking access to class '{}'", (Object)fullClassName);
        if (this.securityManager != null) {
            try {
                this.securityManager.checkPackageAccess(fullClassName);
            }
            catch (SecurityException ex) {
                LOGGER.error("Access denied by SecurityManager for class '{}'", (Object)fullClassName);
                return false;
            }
        }
        boolean allowed = false;
        for (Pattern pattern : this.whiteList) {
            if (!pattern.matcher(fullClassName).matches()) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            LOGGER.warn("Classname failed to match whitelist: '{}'", (Object)fullClassName);
            return false;
        }
        for (Pattern pattern : this.blackList) {
            if (!pattern.matcher(fullClassName).matches()) continue;
            LOGGER.error("Access to class '{}' denied by blacklist pattern: {}", (Object)fullClassName, (Object)pattern.pattern());
            return false;
        }
        LOGGER.debug("Access allowed for class '{}'", (Object)fullClassName);
        return true;
    }
}

