/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.service;

import com.google.inject.Inject;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.datastruct.ValueNotFoundException;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import org.forgerock.openam.core.CoreWrapper;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.openam.scripting.service.ScriptConfigurationQueryFilterVisitor;
import org.forgerock.openam.scripting.service.ScriptingService;
import org.forgerock.openam.utils.Time;
import org.forgerock.util.Reject;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;

public class ScriptConfigurationService
implements ScriptingService,
ServiceListener {
    private static final ScriptConfigurationQueryFilterVisitor SCRIPT_CONFIGURATION_QUERY_FILTER_VISITOR = new ScriptConfigurationQueryFilterVisitor();
    private final Logger logger;
    private final String realm;
    private final CoreWrapper coreWrapper;
    private final ServiceConfigManager scm;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private Map<String, ScriptConfiguration> realmConfigurations;
    @GuardedBy(value="lock")
    private Map<String, ScriptConfiguration> globalConfigurations;

    @Inject
    public ScriptConfigurationService(Logger logger, String realm, CoreWrapper coreWrapper, ServiceConfigManager scm) {
        Reject.ifNull((Object)realm);
        this.logger = logger;
        this.realm = realm;
        this.coreWrapper = coreWrapper;
        this.scm = scm;
        this.init();
    }

    private void init() {
        this.reload();
        this.scm.addListener((ServiceListener)this);
    }

    private void reload() {
        int i;
        int readLocked = this.lock.getReadHoldCount();
        for (i = 0; i < readLocked; ++i) {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            try {
                this.realmConfigurations = this.getScriptConfigurations(this.getSubOrgConfig());
                this.globalConfigurations = this.getScriptConfigurations(this.getSubGlobalConfig());
            }
            catch (SSOException | SMSException | ScriptException e) {
                throw new IllegalStateException("Could not initialise script configurations for realm " + this.realm, (Throwable)e);
            }
        }
        finally {
            for (i = 0; i < readLocked; ++i) {
                this.lock.readLock().lock();
            }
            this.lock.writeLock().unlock();
        }
    }

    private Map<String, ScriptConfiguration> getScriptConfigurations(ServiceConfig config) throws SMSException, SSOException, ScriptException {
        LinkedHashMap<String, ScriptConfiguration> configurations = new LinkedHashMap<String, ScriptConfiguration>();
        Set uuids = config.getSubConfigNames();
        for (String id : uuids) {
            configurations.put(id, this.scriptConfigurationFromMap(id, config.getSubConfig(id).getAttributesForRead()));
        }
        return configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptConfiguration create(ScriptConfiguration config, Subject subject) throws ScriptException {
        this.lock.readLock().lock();
        try {
            this.failIfUuidExists(config.getId());
            this.failIfNameExists(config.getName());
            ScriptConfiguration updatedConfig = this.setMetaData(config, subject);
            this.save(updatedConfig);
            ScriptConfiguration scriptConfiguration = updatedConfig;
            return scriptConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptConfiguration update(ScriptConfiguration config, Subject subject) throws ScriptException {
        this.lock.readLock().lock();
        try {
            ScriptConfiguration oldConfig = this.get(config.getId());
            if (!oldConfig.getName().equals(config.getName())) {
                this.failIfNameExists(config.getName());
            }
            ScriptConfiguration updatedConfig = this.setMetaData(config, subject);
            this.save(updatedConfig);
            ScriptConfiguration scriptConfiguration = updatedConfig;
            return scriptConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String uuid) throws ScriptException {
        Reject.ifTrue((this.lock.getReadHoldCount() > 0 ? 1 : 0) != 0, (String)"Should not already be locked for reading");
        this.lock.readLock().lock();
        try {
            this.failIfUuidDoesNotExist(uuid);
            ScriptConfiguration scriptConfig = this.get(uuid);
            if (this.containsGlobalUuid(uuid) || this.isDefaultScript(scriptConfig)) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.DELETING_DEFAULT_SCRIPT, scriptConfig.getName());
            }
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                int usageCount = this.getUsageCount(scriptConfig);
                if (usageCount > 0) {
                    if (usageCount == 1) {
                        throw new ScriptException(ScriptConstants.ScriptErrorCode.DELETING_SCRIPT_IN_USE_SINGULAR, scriptConfig.getName());
                    }
                    throw new ScriptException(ScriptConstants.ScriptErrorCode.DELETING_SCRIPT_IN_USE_PLURAL, scriptConfig.getName(), Integer.toString(usageCount));
                }
                this.getSubOrgConfig().removeSubConfig(uuid);
                this.realmConfigurations.remove(uuid);
            }
            catch (SSOException | SMSException e) {
                throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.DELETE_FAILED, e, uuid, this.realm);
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<ScriptConfiguration> getAll() {
        HashSet<ScriptConfiguration> configurations = new HashSet<ScriptConfiguration>();
        this.lock.readLock().lock();
        try {
            configurations.addAll(this.realmConfigurations.values());
            configurations.addAll(this.globalConfigurations.values());
            HashSet<ScriptConfiguration> hashSet = configurations;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptConfiguration get(String uuid) throws ScriptException {
        this.lock.readLock().lock();
        try {
            this.failIfUuidDoesNotExist(uuid);
            ScriptConfiguration realmConfiguration = this.realmConfigurations.get(uuid);
            ScriptConfiguration scriptConfiguration = realmConfiguration != null ? realmConfiguration : this.globalConfigurations.get(uuid);
            return scriptConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<ScriptConfiguration> get(QueryFilter<String> queryFilter) {
        return (Set)queryFilter.accept((QueryFilterVisitor)SCRIPT_CONFIGURATION_QUERY_FILTER_VISITOR, this.getAll());
    }

    private void failIfNameExists(String name) throws ScriptException {
        if (this.containsName(name)) {
            throw ScriptException.createAndLogDebug(this.logger, ScriptConstants.ScriptErrorCode.SCRIPT_NAME_EXISTS, name, this.realm);
        }
    }

    private void failIfUuidExists(String uuid) throws ScriptException {
        if (this.containsUuid(uuid)) {
            throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.SCRIPT_UUID_EXISTS, uuid, this.realm);
        }
    }

    private void failIfUuidDoesNotExist(String uuid) throws ScriptException {
        if (!this.containsUuid(uuid)) {
            throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.SCRIPT_UUID_NOT_FOUND, uuid, this.realm);
        }
    }

    private ScriptConfiguration setMetaData(ScriptConfiguration config, Subject subject) throws ScriptException {
        long now = Time.newDate().getTime();
        String principalName = SubjectUtils.getPrincipalId((Subject)subject);
        ScriptConfiguration.Builder builder = config.populatedBuilder();
        if (this.containsUuid(config.getId())) {
            ScriptConfiguration oldConfig = this.get(config.getId());
            builder.setCreatedBy(oldConfig.getCreatedBy());
            builder.setCreationDate(oldConfig.getCreationDate());
        } else {
            builder.setCreatedBy(principalName);
            builder.setCreationDate(now);
        }
        builder.setLastModifiedBy(principalName);
        builder.setLastModifiedDate(now);
        return builder.build();
    }

    private void save(ScriptConfiguration config) throws ScriptException {
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        try {
            this.createCollectionConfig();
            Map<String, Set<String>> data = this.getScriptConfigurationData(config);
            if (this.containsGlobalUuid(config.getId())) {
                this.getSubGlobalConfig().getSubConfig(config.getId()).setAttributes(data);
                this.globalConfigurations.put(config.getId(), config);
            } else {
                if (this.containsOrgUuid(config.getId())) {
                    this.getSubOrgConfig().getSubConfig(config.getId()).setAttributes(data);
                } else {
                    this.getSubOrgConfig().addSubConfig(config.getId(), "scriptConfiguration", 0, data);
                }
                this.realmConfigurations.put(config.getId(), config);
            }
        }
        catch (SSOException | SMSException e) {
            if ("sms-INSUFFICIENT_ACCESS_RIGHTS".equals(((L10NMessage)e).getErrorCode())) {
                throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.INSUFFICIENT_PRIVILEGES, e, config.getName());
            }
            throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.SAVE_FAILED, e, config.getId(), this.realm);
        }
        finally {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
        }
    }

    private boolean containsUuid(String uuid) throws ScriptException {
        return this.containsOrgUuid(uuid) || this.containsGlobalUuid(uuid);
    }

    private boolean containsOrgUuid(String uuid) throws ScriptException {
        return this.realmConfigurations.containsKey(uuid);
    }

    private boolean containsGlobalUuid(String uuid) throws ScriptException {
        return this.globalConfigurations.containsKey(uuid);
    }

    private boolean containsName(String name) throws ScriptException {
        for (Map configurations : Arrays.asList(this.globalConfigurations, this.realmConfigurations)) {
            for (ScriptConfiguration sc : configurations.values()) {
                if (!sc.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Set<String>> getScriptConfigurationData(ScriptConfiguration config) {
        HashMap<String, Set<String>> dataMap = new HashMap<String, Set<String>>();
        dataMap.put("name", Collections.singleton(config.getName()));
        dataMap.put("description", Collections.singleton(config.getDescription()));
        dataMap.put("script", Collections.singleton(config.getScript()));
        dataMap.put("context", Collections.singleton(config.getContext().name()));
        dataMap.put("language", Collections.singleton(config.getLanguage().name()));
        dataMap.put("createdBy", Collections.singleton(config.getCreatedBy()));
        dataMap.put("creationDate", Collections.singleton(String.valueOf(config.getCreationDate())));
        dataMap.put("lastModifiedBy", Collections.singleton(config.getLastModifiedBy()));
        dataMap.put("lastModifiedDate", Collections.singleton(String.valueOf(config.getLastModifiedDate())));
        return dataMap;
    }

    private ScriptConfiguration scriptConfigurationFromMap(String uuid, Map<String, Set<String>> data) throws ScriptException {
        String script = CollectionHelper.getMapAttr(data, (String)"script");
        return ScriptConfiguration.builder().setId(uuid).setName(CollectionHelper.getMapAttr(data, (String)"name")).setDescription(CollectionHelper.getMapAttr(data, (String)"description")).setContext(ScriptConstants.getContextFromString(CollectionHelper.getMapAttr(data, (String)"context"))).setLanguage(ScriptConstants.getLanguageFromString(CollectionHelper.getMapAttr(data, (String)"language"))).setScript(script == null ? "" : script).setCreatedBy(CollectionHelper.getMapAttr(data, (String)"createdBy", (String)"")).setCreationDate(CollectionHelper.getMapAttrAsDateLong(data, (String)"creationDate", (Logger)this.logger)).setLastModifiedBy(CollectionHelper.getMapAttr(data, (String)"lastModifiedBy", (String)"")).setLastModifiedDate(CollectionHelper.getMapAttrAsDateLong(data, (String)"lastModifiedDate", (Logger)this.logger)).build();
    }

    private void createCollectionConfig() throws SSOException, SMSException {
        ServiceConfig orgConfig = this.getOrgConfig();
        if (orgConfig.getSubConfig("scriptConfigurations") == null) {
            orgConfig.addSubConfig("scriptConfigurations", "scriptConfigurations", 0, Collections.EMPTY_MAP);
        }
    }

    private ServiceConfig getOrgConfig() throws SMSException, SSOException {
        ServiceConfig orgConfig = this.scm.getOrganizationConfig(this.realm, null);
        if (orgConfig == null) {
            throw new SMSException("Configuration 'ScriptingService' in realm '" + this.realm + "' could not be retrieved.");
        }
        return orgConfig;
    }

    private ServiceConfig getGlobalConfig() throws SMSException, SSOException {
        ServiceConfig globalConfig = this.scm.getGlobalConfig(null);
        if (globalConfig == null) {
            throw new SMSException("Global Configuration for 'ScriptingService' could not be retrieved.");
        }
        return globalConfig;
    }

    private ServiceConfig getSubOrgConfig() throws SMSException, SSOException {
        ServiceConfig config = this.getOrgConfig().getSubConfig("scriptConfigurations");
        if (config == null) {
            throw new SMSException("Configuration 'scriptConfigurations' in organization 'ScriptingService' could not be retrieved.");
        }
        return config;
    }

    private ServiceConfig getSubGlobalConfig() throws SMSException, SSOException {
        ServiceConfig config = this.getGlobalConfig().getSubConfig("globalScripts");
        if (config == null) {
            throw new SMSException("Global Configuration for 'ScriptingService' could not be retrieved.");
        }
        return config;
    }

    private SSOToken getToken() throws SSOException {
        return this.coreWrapper.getAdminToken();
    }

    private int getUsageCount(ScriptConfiguration script) throws ScriptException {
        try {
            switch (script.getContext()) {
                case AUTHENTICATION_CLIENT_SIDE: {
                    return this.clientSideAuthenticationUsageCount(script.getId());
                }
                case AUTHENTICATION_SERVER_SIDE: {
                    return this.serverSideAuthenticationUsageCount(script.getId());
                }
                case OIDC_CLAIMS: {
                    return this.oidcClaimsUsageCount(script.getId());
                }
                case POLICY_CONDITION: {
                    return this.policyConditionUsageCount(script.getId());
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("unknown script context {} in script {}", new Object[]{script.getContext(), script.getName()}));
        }
        catch (SSOException | SMSException e) {
            this.logger.error("getUsageCount failed with exception with script {} id {}", new Object[]{script.getName(), script.getId(), e});
            return 0;
        }
    }

    private int getUsageCount(String dn, String search) throws SSOException, SMSException {
        try {
            return SMSEntry.search((SSOToken)this.getToken(), (String)dn, (String)search, (int)0, (int)0, (boolean)false, (boolean)false).size();
        }
        catch (SMSException sMSException) {
            return 0;
        }
    }

    private boolean isDefaultScript(ScriptConfiguration scriptConfig) {
        try {
            int usageCount = this.getUsageCount(this.getScriptingServiceGlobalConfig(), this.getDefaultScriptSearchString(scriptConfig.getId()));
            return usageCount > 0;
        }
        catch (SSOException | SMSException e) {
            this.logger.error("isDefaultScript caught exception with script {} UUID {}", new Object[]{scriptConfig.getName(), scriptConfig.getId(), e});
            return false;
        }
    }

    private int clientSideAuthenticationUsageCount(String uuid) throws SSOException, SMSException {
        return this.getUsageCount(this.getScriptedServiceBaseDN(), this.getClientSideScriptedAuthSearchString(uuid)) + this.getUsageCount(this.getDeviceIdMatchServiceBaseDN(), this.getClientSideScriptedAuthSearchString(uuid));
    }

    private int serverSideAuthenticationUsageCount(String uuid) throws SSOException, SMSException {
        return this.getUsageCount(this.getScriptedServiceBaseDN(), this.getServerSideScriptedAuthSearchString(uuid)) + this.getUsageCount(this.getDeviceIdMatchServiceBaseDN(), this.getServerSideScriptedAuthSearchString(uuid));
    }

    private int oidcClaimsUsageCount(String uuid) throws SSOException, SMSException {
        SMSEntry smsEntry = new SMSEntry(this.getToken(), this.getOAuth2ProviderBaseDN());
        Map attributes = smsEntry.getAttributes();
        try {
            Set sunKeyValues = CollectionHelper.getMapSetThrows((Map)attributes, (String)"sunKeyValue");
            if (sunKeyValues.contains("forgerock-oauth2-provider-oidc-claims-extension-script=" + uuid)) {
                return 1;
            }
        }
        catch (ValueNotFoundException valueNotFoundException) {
            // empty catch block
        }
        return 0;
    }

    private int policyConditionUsageCount(String uuid) throws SSOException, SMSException {
        return this.getUsageCount(this.getPolicyBaseDN(), this.getPolicySearchString(uuid));
    }

    private String getScriptingServiceGlobalConfig() {
        return "ou=default,ou=GlobalConfig,ou=1.0,ou=ScriptingService,ou=services," + DNMapper.orgNameToDN((String)this.realm);
    }

    private String getOAuth2ProviderBaseDN() {
        return "ou=default,ou=OrganizationConfig,ou=1.0,ou=OAuth2Provider,ou=services," + DNMapper.orgNameToDN((String)this.realm);
    }

    private String getScriptedServiceBaseDN() {
        return "ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthScriptedService,ou=services," + DNMapper.orgNameToDN((String)this.realm);
    }

    private String getDeviceIdMatchServiceBaseDN() {
        return "ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthDeviceIdMatchService,ou=services," + DNMapper.orgNameToDN((String)this.realm);
    }

    private String getPolicyBaseDN() {
        return "ou=default,ou=default,ou=OrganizationConfig,ou=1.0,ou=sunEntitlementIndexes,ou=services," + DNMapper.orgNameToDN((String)this.realm);
    }

    private String getDefaultScriptSearchString(String uuid) {
        return "(&(sunserviceID=scriptContext)(sunKeyValue=defaultScript=" + uuid + "))";
    }

    private String getClientSideScriptedAuthSearchString(String uuid) {
        return "(&(sunserviceID=serverconfig)(sunKeyValue=iplanet-am-auth-scripted-client-script=" + uuid + "))";
    }

    private String getServerSideScriptedAuthSearchString(String uuid) {
        return "(&(sunserviceID=serverconfig)(sunKeyValue=iplanet-am-auth-scripted-server-script=" + uuid + "))";
    }

    private String getPolicySearchString(String uuid) {
        return "(&(sunserviceID=indexes)(sunKeyValue=serializable*" + uuid + "*))";
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (serviceName.equals("ScriptingService")) {
            this.reload();
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (serviceName.equals("ScriptingService")) {
            this.reload();
        }
    }
}

