/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.service;

import com.google.inject.name.Named;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.openam.core.CoreWrapper;
import org.forgerock.openam.scripting.service.ScriptConfigurationService;
import org.forgerock.openam.scripting.service.ScriptingService;
import org.forgerock.openam.utils.RealmNormaliser;
import org.slf4j.Logger;

@Singleton
public class ScriptingServiceFactory {
    private final Logger logger;
    private final Map<String, ScriptingService> services = new ConcurrentSkipListMap<String, ScriptingService>(String.CASE_INSENSITIVE_ORDER);
    private final CoreWrapper coreWrapper;
    private final RealmNormaliser realmNormaliser;
    private final ServiceConfigManager scm;

    @Inject
    public ScriptingServiceFactory(@Named(value="ScriptLogger") Logger logger, CoreWrapper coreWrapper, RealmNormaliser realmNormaliser) {
        this.logger = logger;
        this.coreWrapper = coreWrapper;
        this.realmNormaliser = realmNormaliser;
        try {
            this.scm = coreWrapper.getServiceConfigManager("ScriptingService", coreWrapper.getAdminToken());
        }
        catch (SSOException | SMSException e) {
            throw new IllegalStateException();
        }
    }

    public ScriptingService create(String realm) {
        try {
            realm = this.realmNormaliser.normalise(realm);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Cannot find realm " + realm, e);
        }
        ScriptingService service = this.services.get(realm);
        if (service == null) {
            service = this.forRealm(realm);
        }
        return service;
    }

    private synchronized ScriptingService forRealm(String realm) {
        if (!this.services.containsKey(realm)) {
            this.services.put(realm, new ScriptConfigurationService(this.logger, realm, this.coreWrapper, this.scm));
        }
        return this.services.get(realm);
    }
}

