/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;

public class DatasetAdaptors {
    public static <INSTANCE> List<INSTANCE> asList(Dataset<INSTANCE> dataset) {
        if (dataset instanceof ListDataset) {
            return (ListDataset)dataset;
        }
        ArrayList list = new ArrayList();
        for (Object instance : dataset) {
            list.add(instance);
        }
        return list;
    }

    public static <ANN, INSTANCE> GroupedDataset<ANN, ListDataset<INSTANCE>, INSTANCE> flattenListGroupedDataset(GroupedDataset<ANN, ? extends ListDataset<List<INSTANCE>>, ? extends List<INSTANCE>> dataset) {
        MapBackedDataset g = new MapBackedDataset();
        for (Object a : dataset.getGroups()) {
            ListDataset l = (ListDataset)dataset.getInstances(a);
            ListBackedDataset newListDataset = new ListBackedDataset();
            for (List le : l) {
                for (Object ll : le) {
                    newListDataset.add(ll);
                }
            }
            g.add(a, (Dataset)newListDataset);
        }
        return g;
    }

    public static <ANN, DATASET extends Dataset<INSTANCE>, INSTANCE> GroupedDataset<ANN, DATASET, INSTANCE> getGroupedDatasetSubset(GroupedDataset<ANN, DATASET, INSTANCE> data, ANN ... groups) {
        MapBackedDataset newDataset = new MapBackedDataset();
        for (ANN group : groups) {
            Dataset ds = data.getInstances(group);
            if (ds == null) continue;
            newDataset.put(group, ds);
        }
        return newDataset;
    }

    public static <ANN, DATASET extends ListDataset<INSTANCE>, INSTANCE> GroupedDataset<ANN, ListBackedDataset<INSTANCE>, INSTANCE> getRegroupedDataset(GroupedDataset<ANN, DATASET, INSTANCE> data, Map<ANN, ANN[]> regroupCriteria) {
        MapBackedDataset newDataset = new MapBackedDataset();
        for (ANN newGroup : regroupCriteria.keySet()) {
            for (ANN oldGroup : regroupCriteria.get(newGroup)) {
                ListDataset ds = (ListDataset)data.getInstances(oldGroup);
                if (ds == null) continue;
                ListBackedDataset lbd = new ListBackedDataset();
                lbd.addAll((Collection)ds);
                if (newDataset.get(newGroup) != null) {
                    ((ListBackedDataset)newDataset.get(newGroup)).addAll((Collection)lbd);
                    continue;
                }
                newDataset.put(newGroup, (Dataset)lbd);
            }
        }
        return newDataset;
    }
}

