/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval.analysers;

import com.googlecode.jatl.Html;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.procedure.TDoubleProcedure;
import gnu.trove.procedure.TObjectDoubleProcedure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.AnalysisResult;

public class PrecisionAtNResult<QUERY>
implements AnalysisResult {
    TObjectDoubleHashMap<QUERY> allScores = new TObjectDoubleHashMap();
    int N;

    public PrecisionAtNResult(int N) {
        this.N = N;
    }

    private DescriptiveStatistics computeStats() {
        final DescriptiveStatistics ds = new DescriptiveStatistics();
        this.allScores.forEachValue(new TDoubleProcedure(){

            public boolean execute(double value) {
                ds.addValue(value);
                return true;
            }
        });
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHTML(File file, final String title, final String info) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            new Html(fw){
                {
                    super(x0);
                    this.html();
                    this.head();
                    this.title(title);
                    this.end();
                    this.body();
                    ((Html)((Html)this.h1()).text(title)).end();
                    ((Html)((Html)this.div()).text(info)).end();
                    this.hr();
                    ((Html)((Html)this.pre()).text(PrecisionAtNResult.this.toString())).end();
                    this.endAll();
                }
            };
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public String toString() {
        return this.getSummaryReport();
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) throws JRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) throws JRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSummaryReport() {
        StringBuilder outBuffer = new StringBuilder();
        DescriptiveStatistics ds = this.computeStats();
        outBuffer.append("Aggregate P@" + this.N + " Statistics:\n");
        outBuffer.append(String.format("%-15s\t%6d\n", "num_q", ds.getN()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "min", ds.getMin()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "max", ds.getMax()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "mean", ds.getMean()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "std dev", ds.getStandardDeviation()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "median", ds.getPercentile(50.0)));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "skewness", ds.getSkewness()));
        outBuffer.append(String.format("%-15s\t%6.4f\n", "kurtosis", ds.getKurtosis()));
        return outBuffer.toString();
    }

    @Override
    public String getDetailReport() {
        final StringBuilder outBuffer = new StringBuilder();
        this.allScores.forEachEntry(new TObjectDoubleProcedure<QUERY>(){

            public boolean execute(QUERY a, double b) {
                String id = a instanceof Identifiable ? ((Identifiable)a).getID() : a.toString();
                outBuffer.append(String.format("P@%-11s\t%10s\t%6.4f\n", PrecisionAtNResult.this.N, id, b));
                return true;
            }
        });
        outBuffer.append("\n");
        outBuffer.append(this.getSummaryReport());
        return outBuffer.toString();
    }
}

