/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation.cross;

import java.util.Iterator;
import java.util.List;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.experiment.validation.ValidationData;
import org.openimaj.experiment.validation.cross.CrossValidationIterable;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class LeaveOneOut<INSTANCE>
implements CrossValidator<ListDataset<INSTANCE>> {
    @Override
    public CrossValidationIterable<ListDataset<INSTANCE>> createIterable(ListDataset<INSTANCE> data) {
        return new LeaveOneOutIterable(data);
    }

    public String toString() {
        return "Leave-One-Out Cross Validation (LOOCV)";
    }

    private class LeaveOneOutIterable
    implements CrossValidationIterable<ListDataset<INSTANCE>> {
        private ListDataset<INSTANCE> dataset;
        private List<INSTANCE> listView;

        public LeaveOneOutIterable(ListDataset<INSTANCE> dataset) {
            this.dataset = dataset;
            this.listView = DatasetAdaptors.asList(dataset);
        }

        @Override
        public int numberIterations() {
            return this.dataset.size();
        }

        @Override
        public Iterator<ValidationData<ListDataset<INSTANCE>>> iterator() {
            return new Iterator<ValidationData<ListDataset<INSTANCE>>>(){
                int validationIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.validationIndex < LeaveOneOutIterable.this.dataset.size();
                }

                @Override
                public ValidationData<ListDataset<INSTANCE>> next() {
                    ListBackedDataset training = new ListBackedDataset((List)new SkippingListView(LeaveOneOutIterable.this.listView, new int[]{this.validationIndex}));
                    int[] nArray = new int[]{this.validationIndex++};
                    ListBackedDataset validation = new ListBackedDataset((List)new AcceptingListView(LeaveOneOutIterable.this.listView, nArray));
                    return new DefaultValidationData<ListBackedDataset>(training, validation);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

