/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot;

import java.util.Arrays;
import java.util.List;
import org.openingo.spring.boot.SpringBootVersionX;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public final class SpringApplicationX {
    public static SpringApplicationX springApplicationX;
    public static SpringApplication springApplication;
    public static ConfigurableApplicationContext applicationContext;
    public static boolean isDebugging;
    public static ConfigurableEnvironment environment;
    public static Class<?> mainApplicationClass;
    public static String applicationPackage;
    public static String springBootVersion;
    public static String springBootVersionX;

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return SpringApplicationX.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        springApplication = new SpringApplication((Class[])primarySources);
        applicationContext = springApplication.run(args);
        springApplicationX = new SpringApplicationX();
        SpringApplicationX.initSpringApplicationX();
        return applicationContext;
    }

    private static boolean isDebugging() {
        List<String> envs = Arrays.asList(environment.getActiveProfiles());
        return !envs.contains("prod");
    }

    private static void initSpringApplicationX() {
        environment = applicationContext.getEnvironment();
        isDebugging = SpringApplicationX.isDebugging();
        SpringApplicationX.initMainApplicationInfo(springApplication.getMainApplicationClass());
    }

    public static void initMainApplicationInfo(Class<?> mainApplicationClass) {
        SpringApplicationX.mainApplicationClass = mainApplicationClass;
        applicationPackage = mainApplicationClass.getPackage().getName();
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static void applicationInfo() {
        System.out.println(applicationPackage);
    }

    static {
        isDebugging = false;
        environment = null;
        mainApplicationClass = null;
        applicationPackage = null;
        springBootVersion = SpringBootVersion.getVersion();
        springBootVersionX = SpringBootVersionX.getVersion();
    }
}

