/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis;

import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.DefaultBoundGeoOperationsX;
import org.springframework.data.redis.core.DefaultBoundListOperationsX;
import org.springframework.data.redis.core.DefaultBoundOperationsX;
import org.springframework.data.redis.core.DefaultBoundSetOperationsX;
import org.springframework.data.redis.core.DefaultBoundValueOperationsX;
import org.springframework.data.redis.core.DefaultBoundZSetOperationsX;
import org.springframework.data.redis.core.DefaultClusterOperationsX;
import org.springframework.data.redis.core.DefaultGeoOperationsX;
import org.springframework.data.redis.core.DefaultHashOperationsX;
import org.springframework.data.redis.core.DefaultHyperLogLogOperationsX;
import org.springframework.data.redis.core.DefaultListOperationsX;
import org.springframework.data.redis.core.DefaultSetOperationsX;
import org.springframework.data.redis.core.DefaultValueOperationsX;
import org.springframework.data.redis.core.DefaultZSetOperationsX;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.Nullable;

public class RedisTemplateX<V> {
    @Autowired
    RedisTemplate<String, V> redisTemplate;
    @Autowired
    IKeyNamingPolicy keyNamingPolicy;
    @Nullable
    private ValueOperations<String, V> valueOps;
    @Nullable
    private ListOperations<String, V> listOps;
    @Nullable
    private SetOperations<String, V> setOps;
    @Nullable
    private ZSetOperations<String, V> zSetOps;
    @Nullable
    private GeoOperations<String, V> geoOps;
    @Nullable
    private HyperLogLogOperations<String, V> hllOps;

    public ClusterOperations<String, V> opsForCluster() {
        return new DefaultClusterOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
    }

    public GeoOperations<String, V> opsForGeo() {
        if (this.geoOps == null) {
            this.geoOps = new DefaultGeoOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.geoOps;
    }

    public BoundGeoOperations<String, V> boundGeoOps(String key) {
        return new DefaultBoundGeoOperationsX<V>(key, this.redisTemplate, this.keyNamingPolicy);
    }

    public <HK, HV> BoundHashOperations<String, HK, HV> boundHashOps(String key) {
        return new DefaultBoundOperationsX(key, (RedisOperations<String, ?>)this.redisTemplate, this.keyNamingPolicy);
    }

    public <HK, HV> HashOperations<String, HK, HV> opsForHash() {
        return new DefaultHashOperationsX(this.redisTemplate, this.keyNamingPolicy);
    }

    public HyperLogLogOperations<String, V> opsForHyperLogLog() {
        if (this.hllOps == null) {
            this.hllOps = new DefaultHyperLogLogOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.hllOps;
    }

    public ListOperations<String, V> opsForList() {
        if (this.listOps == null) {
            this.listOps = new DefaultListOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.listOps;
    }

    public BoundListOperations<String, V> boundListOps(String key) {
        return new DefaultBoundListOperationsX<V>(key, this.redisTemplate, this.keyNamingPolicy);
    }

    public BoundSetOperations<String, V> boundSetOps(String key) {
        return new DefaultBoundSetOperationsX<V>(key, this.redisTemplate, this.keyNamingPolicy);
    }

    public SetOperations<String, V> opsForSet() {
        if (this.setOps == null) {
            this.setOps = new DefaultSetOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.setOps;
    }

    public BoundValueOperations<String, V> boundValueOps(String key) {
        return new DefaultBoundValueOperationsX<V>(key, this.redisTemplate, this.keyNamingPolicy);
    }

    public ValueOperations<String, V> opsForValue() {
        if (this.valueOps == null) {
            this.valueOps = new DefaultValueOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.valueOps;
    }

    public BoundZSetOperations<String, V> boundZSetOps(String key) {
        return new DefaultBoundZSetOperationsX<V>(key, this.redisTemplate, this.keyNamingPolicy);
    }

    public ZSetOperations<String, V> opsForZSet() {
        if (this.zSetOps == null) {
            this.zSetOps = new DefaultZSetOperationsX<V>(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.zSetOps;
    }
}

