/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis.config;

import org.openingo.spring.extension.data.redis.RedisTemplateX;
import org.openingo.spring.extension.data.redis.naming.DefaultKeyNamingPolicy;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.openingo.spring.extension.data.redis.serializer.FstSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnProperty(prefix="openingo.redis", name={"enable"}, havingValue="true")
@ConditionalOnClass(value={RedisTemplate.class})
public class RedisConfig {
    @Bean
    @ConditionalOnMissingBean
    public <V> RedisTemplateX<V> redisTemplateX() {
        return new RedisTemplateX();
    }

    @Bean
    public <V> RedisTemplate<String, V> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer(this.valueSerializer());
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public <V> RedisSerializer<V> valueSerializer() {
        return new FstSerializer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IKeyNamingPolicy keyNamingPolicy() {
        return new DefaultKeyNamingPolicy();
    }
}

