/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.http.request;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.openingo.jdkits.JacksonKit;
import org.openingo.jdkits.SystemClockKit;
import org.openingo.jdkits.ThreadLocalKit;
import org.openingo.jdkits.ValidateKit;
import org.openingo.spring.http.request.RequestReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class RequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);
    @Autowired
    MappingJackson2HttpMessageConverter converter;
    private final ThreadLocalKit<Long> processingTimeThreadLocal = new ThreadLocalKit();

    private void handlerStart() {
        this.processingTimeThreadLocal.set((Object)SystemClockKit.now());
    }

    private Double getProcessingSeconds() {
        long startTime = (Long)this.processingTimeThreadLocal.get();
        return (double)(SystemClockKit.now() - startTime) / 1000.0;
    }

    @Pointcut(value="execution(public * *.*..controller..*.*(..))")
    public void log() {
    }

    @Around(value="log()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        this.handlerStart();
        Object proceed = point.proceed();
        double processingTime = this.getProcessingSeconds();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        RequestReporter httpRequestReporter = RequestReporter.getInstance();
        if (ValidateKit.isNull((Object)request)) {
            StringBuilder reportInfoBuilder = new StringBuilder("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\n");
            reportInfoBuilder.append("Processing Time  : ").append(processingTime).append("s\n");
            httpRequestReporter.report(reportInfoBuilder.toString());
            return proceed;
        }
        httpRequestReporter.setPoint(point);
        httpRequestReporter.setProcessingTime(processingTime);
        ServletServerHttpRequest serverHttpRequest = new ServletServerHttpRequest(request);
        httpRequestReporter.setRequest(serverHttpRequest);
        Object body = null;
        if (ValidateKit.isNotNull((Object)request.getContentType())) {
            body = "<File>";
            try {
                body = this.converter.read(Object.class, (HttpInputMessage)serverHttpRequest);
                body = JacksonKit.toJson((Object)body);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    body = null;
                }
                log.error(e.toString());
            }
        }
        httpRequestReporter.setBodyData(body);
        if (ValidateKit.isNotNull((Object)proceed)) {
            httpRequestReporter.setResponseData(JacksonKit.toJson((Object)proceed));
        }
        httpRequestReporter.report();
        return proceed;
    }
}

