/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.http.request;

import java.time.LocalDateTime;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.openingo.jdkits.IPKit;
import org.openingo.jdkits.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServletServerHttpRequest;

public final class RequestReporter {
    private static final Logger log = LoggerFactory.getLogger(RequestReporter.class);
    private ServletServerHttpRequest request;
    private Double processingTime;
    private Object bodyData;
    private Object responseData;
    private ProceedingJoinPoint point;
    private static int maxOutputLengthOfParaValue = 512;

    private RequestReporter() {
    }

    public static RequestReporter getInstance() {
        return new RequestReporter();
    }

    public void report() {
        Enumeration e;
        String urlQuery;
        HttpServletRequest servletRequest = this.request.getServletRequest();
        StringBuilder reportInfoBuilder = new StringBuilder("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\n");
        reportInfoBuilder.append("Client IP  : ").append(IPKit.getRequestIP((HttpServletRequest)servletRequest)).append(" ").append("\n");
        reportInfoBuilder.append("Request Time  : ").append(LocalDateTime.now()).append(" ").append("\n");
        Class<?> target = this.point.getTarget().getClass();
        reportInfoBuilder.append("Controller  : ").append(target.getName()).append(".(").append(target.getSimpleName()).append(".java:1)").append("\n");
        reportInfoBuilder.append("URI  : ").append(this.request.getURI()).append(" ").append("\n");
        reportInfoBuilder.append("Handler(Action)  : ").append(this.point.getSignature().getName()).append("\n");
        reportInfoBuilder.append("Method  : ").append(this.request.getMethod()).append("\n");
        reportInfoBuilder.append("Processing Time  : ").append(this.processingTime).append("s\n");
        reportInfoBuilder.append("Header(s)  : ").append(this.request.getHeaders()).append("\n");
        if (ValidateKit.isNotNull((Object)this.bodyData)) {
            reportInfoBuilder.append("Body  : ").append(this.bodyData).append("\n");
        }
        if (ValidateKit.isNotNull((Object)(urlQuery = servletRequest.getQueryString()))) {
            reportInfoBuilder.append("UrlQuery  : ").append(urlQuery).append("\n");
        }
        if ((e = servletRequest.getParameterNames()).hasMoreElements()) {
            reportInfoBuilder.append("Parameter(s)  : ");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = servletRequest.getParameterValues(name);
                if (values.length == 1) {
                    reportInfoBuilder.append(name).append("=");
                    if (values[0] != null && values[0].length() > maxOutputLengthOfParaValue) {
                        reportInfoBuilder.append(values[0], 0, maxOutputLengthOfParaValue).append("...");
                    } else {
                        reportInfoBuilder.append(values[0]);
                    }
                } else {
                    reportInfoBuilder.append(name).append("[]={");
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            reportInfoBuilder.append(",");
                        }
                        reportInfoBuilder.append(values[i]);
                    }
                    reportInfoBuilder.append("}");
                }
                reportInfoBuilder.append(", ");
            }
            reportInfoBuilder.append("\n");
        }
        if (ValidateKit.isNotNull((Object)this.responseData)) {
            reportInfoBuilder.append("Response  : ").append(this.responseData).append("\n");
        }
        reportInfoBuilder.append("----------------------------------------------------------------\n");
        this.report(reportInfoBuilder.toString());
    }

    public void report(String info) {
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info(info);
        } else {
            System.out.println(info);
        }
    }

    public ServletServerHttpRequest getRequest() {
        return this.request;
    }

    public Double getProcessingTime() {
        return this.processingTime;
    }

    public Object getBodyData() {
        return this.bodyData;
    }

    public Object getResponseData() {
        return this.responseData;
    }

    public ProceedingJoinPoint getPoint() {
        return this.point;
    }

    public void setRequest(ServletServerHttpRequest request) {
        this.request = request;
    }

    public void setProcessingTime(Double processingTime) {
        this.processingTime = processingTime;
    }

    public void setBodyData(Object bodyData) {
        this.bodyData = bodyData;
    }

    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public void setPoint(ProceedingJoinPoint point) {
        this.point = point;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestReporter)) {
            return false;
        }
        RequestReporter other = (RequestReporter)o;
        ServletServerHttpRequest this$request = this.getRequest();
        ServletServerHttpRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Double this$processingTime = this.getProcessingTime();
        Double other$processingTime = other.getProcessingTime();
        if (this$processingTime == null ? other$processingTime != null : !((Object)this$processingTime).equals(other$processingTime)) {
            return false;
        }
        Object this$bodyData = this.getBodyData();
        Object other$bodyData = other.getBodyData();
        if (this$bodyData == null ? other$bodyData != null : !this$bodyData.equals(other$bodyData)) {
            return false;
        }
        Object this$responseData = this.getResponseData();
        Object other$responseData = other.getResponseData();
        if (this$responseData == null ? other$responseData != null : !this$responseData.equals(other$responseData)) {
            return false;
        }
        ProceedingJoinPoint this$point = this.getPoint();
        ProceedingJoinPoint other$point = other.getPoint();
        return !(this$point == null ? other$point != null : !this$point.equals(other$point));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServletServerHttpRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Double $processingTime = this.getProcessingTime();
        result = result * 59 + ($processingTime == null ? 43 : ((Object)$processingTime).hashCode());
        Object $bodyData = this.getBodyData();
        result = result * 59 + ($bodyData == null ? 43 : $bodyData.hashCode());
        Object $responseData = this.getResponseData();
        result = result * 59 + ($responseData == null ? 43 : $responseData.hashCode());
        ProceedingJoinPoint $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        return result;
    }

    public String toString() {
        return "RequestReporter(request=" + this.getRequest() + ", processingTime=" + this.getProcessingTime() + ", bodyData=" + this.getBodyData() + ", responseData=" + this.getResponseData() + ", point=" + this.getPoint() + ")";
    }
}

