/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.scanner;

import java.io.PrintStream;
import org.openingo.jdkits.ValidateKit;
import org.openingo.spring.boot.SpringApplicationX;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.openingo.spring.extension"})
public class ExtensionScanner {
    public ExtensionScanner() {
        PrintStream out = System.out;
        out.print(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, ":: SpringApplicationX ::", AnsiColor.MAGENTA, " is Running..."}));
        out.println();
    }

    @Configuration
    public static class ExtensionConfig {
        public ExtensionConfig() {
            Class<?> mainApplicationClass = this.deduceMainApplicationClass();
            if (ValidateKit.isNotNull(mainApplicationClass)) {
                SpringApplicationX.initMainApplicationInfo(mainApplicationClass);
            }
        }

        private Class<?> deduceMainApplicationClass() {
            try {
                StackTraceElement[] stackTrace;
                for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                    String className = stackTraceElement.getClassName();
                    if (!"main".equals(stackTraceElement.getMethodName()) || className.contains("junit")) continue;
                    return Class.forName(className);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

