/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.error;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openingo.jdkits.ObjectKit;
import org.openingo.jdkits.ThreadLocalKit;
import org.openingo.jdkits.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

public class DefaultErrorAttributesX
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorAttributesX.class);
    private final ThreadLocalKit<Object> handlerHolder = new ThreadLocalKit();
    private final ThreadLocalKit<Exception> exceptionHolder = new ThreadLocalKit();
    private final ThreadLocalKit<Integer> statusHolder = new ThreadLocalKit();
    private final boolean usingException;
    private final boolean usingStatus;

    public DefaultErrorAttributesX() {
        this(false, false);
    }

    public DefaultErrorAttributesX(boolean usingException, boolean usingStatus) {
        super(true);
        this.usingException = usingException;
        this.usingStatus = usingStatus;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map errorAttributes = super.getErrorAttributes(webRequest, includeStackTrace);
        Object handler = this.handlerHolder.get();
        if (ValidateKit.isNotNull((Object)handler)) {
            errorAttributes.put("handler", handler.toString());
        }
        if (this.usingStatus) {
            this.statusHolder.set((Object)ObjectKit.toInteger(errorAttributes.get("status")));
        }
        return errorAttributes;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        this.handlerHolder.set(handler);
        if (this.usingException) {
            this.exceptionHolder.set((Object)exception);
        }
        StringBuilder errorBuilder = new StringBuilder();
        log.error(errorBuilder.append("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\n").toString());
        return super.resolveException(request, response, handler, exception);
    }

    protected Exception getHandlerExecutionException() {
        if (!this.usingException) {
            log.info("\"usingException\" state is Illegal, required true state.");
            return null;
        }
        return (Exception)this.exceptionHolder.get();
    }

    protected Integer getStatus() {
        if (!this.usingStatus) {
            log.info("\"usingStatus\" state is Illegal, required true state.");
            return null;
        }
        return (Integer)this.statusHolder.get();
    }
}

