/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.DefaultGeoOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultGeoOperationsX<M>
extends DefaultGeoOperations<String, M>
implements IKeyNamingPolicy {
    IKeyNamingPolicy keyNamingPolicy;

    public DefaultGeoOperationsX(RedisTemplate<String, M> template, IKeyNamingPolicy keyNamingPolicy) {
        super(template);
        this.keyNamingPolicy = keyNamingPolicy;
    }

    public Long add(String key, Point point, M member) {
        return super.add((Object)this.getKeyName(key), point, member);
    }

    public Long add(String key, RedisGeoCommands.GeoLocation<M> location) {
        return super.add((Object)this.getKeyName(key), location);
    }

    public Long add(String key, Map<M, Point> memberCoordinateMap) {
        return super.add((Object)this.getKeyName(key), memberCoordinateMap);
    }

    public Long add(String key, Iterable<RedisGeoCommands.GeoLocation<M>> geoLocations) {
        return super.add((Object)this.getKeyName(key), geoLocations);
    }

    public Distance distance(String key, M member1, M member2) {
        return super.distance((Object)this.getKeyName(key), member1, member2);
    }

    public Distance distance(String key, M member1, M member2, Metric metric) {
        return super.distance((Object)this.getKeyName(key), member1, member2, metric);
    }

    public List<String> hash(String key, M ... members) {
        return super.hash((Object)this.getKeyName(key), (Object[])members);
    }

    public List<Point> position(String key, M ... members) {
        return super.position((Object)this.getKeyName(key), (Object[])members);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(String key, Circle within) {
        return super.radius((Object)this.getKeyName(key), within);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return super.radius((Object)this.getKeyName(key), within, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(String key, M member, double radius) {
        return super.radius((Object)this.getKeyName(key), member, radius);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(String key, M member, Distance distance) {
        return super.radius((Object)this.getKeyName(key), member, distance);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(String key, M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return super.radius((Object)this.getKeyName(key), member, distance, args);
    }

    public Long remove(String key, M ... members) {
        return super.remove((Object)this.getKeyName(key), (Object[])members);
    }

    @Override
    public String getKeyName(String key) {
        return this.keyNamingPolicy.getKeyName(key);
    }
}

