/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Set;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;

public class DefaultZSetOperationsX<V>
extends DefaultZSetOperations<String, V>
implements IKeyNamingPolicy {
    IKeyNamingPolicy keyNamingPolicy;

    public DefaultZSetOperationsX(RedisTemplate<String, V> template, IKeyNamingPolicy keyNamingPolicy) {
        super(template);
        this.keyNamingPolicy = keyNamingPolicy;
    }

    public Boolean add(String key, V value, double score) {
        return super.add((Object)this.getKeyName(key), value, score);
    }

    public Long add(String key, Set<ZSetOperations.TypedTuple<V>> typedTuples) {
        return super.add((Object)this.getKeyName(key), typedTuples);
    }

    public Double incrementScore(String key, V value, double delta) {
        return super.incrementScore((Object)this.getKeyName(key), value, delta);
    }

    public Long intersectAndStore(String key, String otherKey, String destKey) {
        return super.intersectAndStore((Object)this.getKeyName(key), (Object)this.getKeyName(otherKey), (Object)this.getKeyName(destKey));
    }

    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return super.intersectAndStore((Object)this.getKeyName(key), (Collection)this.getKeyNames(otherKeys), (Object)this.getKeyName(destKey));
    }

    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return super.intersectAndStore((Object)this.getKeyName(key), (Collection)this.getKeyNames(otherKeys), (Object)this.getKeyName(destKey), aggregate, weights);
    }

    public Set<V> range(String key, long start, long end) {
        return super.range((Object)this.getKeyName(key), start, end);
    }

    public Set<V> reverseRange(String key, long start, long end) {
        return super.reverseRange((Object)this.getKeyName(key), start, end);
    }

    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(String key, long start, long end) {
        return super.rangeWithScores((Object)this.getKeyName(key), start, end);
    }

    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(String key, long start, long end) {
        return super.reverseRangeWithScores((Object)this.getKeyName(key), start, end);
    }

    public Set<V> rangeByLex(String key, RedisZSetCommands.Range range) {
        return super.rangeByLex((Object)this.getKeyName(key), range);
    }

    public Set<V> rangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return super.rangeByLex((Object)this.getKeyName(key), range, limit);
    }

    public Set<V> rangeByScore(String key, double min, double max) {
        return super.rangeByScore((Object)this.getKeyName(key), min, max);
    }

    public Set<V> rangeByScore(String key, double min, double max, long offset, long count) {
        return super.rangeByScore((Object)this.getKeyName(key), min, max, offset, count);
    }

    public Set<V> reverseRangeByScore(String key, double min, double max) {
        return super.reverseRangeByScore((Object)this.getKeyName(key), min, max);
    }

    public Set<V> reverseRangeByScore(String key, double min, double max, long offset, long count) {
        return super.reverseRangeByScore((Object)this.getKeyName(key), min, max, offset, count);
    }

    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(String key, double min, double max) {
        return super.rangeByScoreWithScores((Object)this.getKeyName(key), min, max);
    }

    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return super.rangeByScoreWithScores((Object)this.getKeyName(key), min, max, offset, count);
    }

    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(String key, double min, double max) {
        return super.reverseRangeByScoreWithScores((Object)this.getKeyName(key), min, max);
    }

    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return super.reverseRangeByScoreWithScores((Object)this.getKeyName(key), min, max, offset, count);
    }

    public Long rank(String key, Object o) {
        return super.rank((Object)this.getKeyName(key), o);
    }

    public Long reverseRank(String key, Object o) {
        return super.reverseRank((Object)this.getKeyName(key), o);
    }

    public Long remove(String key, Object ... values) {
        return super.remove((Object)this.getKeyName(key), values);
    }

    public Long removeRange(String key, long start, long end) {
        return super.removeRange((Object)this.getKeyName(key), start, end);
    }

    public Long removeRangeByScore(String key, double min, double max) {
        return super.removeRangeByScore((Object)this.getKeyName(key), min, max);
    }

    public Double score(String key, Object o) {
        return super.score((Object)this.getKeyName(key), o);
    }

    public Long count(String key, double min, double max) {
        return super.count((Object)this.getKeyName(key), min, max);
    }

    public Long size(String key) {
        return super.size((Object)this.getKeyName(key));
    }

    public Long zCard(String key) {
        return super.zCard((Object)this.getKeyName(key));
    }

    public Long unionAndStore(String key, String otherKey, String destKey) {
        return super.unionAndStore((Object)this.getKeyName(key), (Object)this.getKeyName(otherKey), (Object)this.getKeyName(destKey));
    }

    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return super.unionAndStore((Object)this.getKeyName(key), (Collection)this.getKeyNames(otherKeys), (Object)this.getKeyName(destKey));
    }

    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return super.unionAndStore((Object)this.getKeyName(key), (Collection)this.getKeyNames(otherKeys), (Object)this.getKeyName(destKey), aggregate, weights);
    }

    public Cursor<ZSetOperations.TypedTuple<V>> scan(String key, ScanOptions options) {
        return super.scan((Object)this.getKeyName(key), options);
    }

    public Set<byte[]> rangeByScore(String key, String min, String max) {
        return super.rangeByScore((Object)this.getKeyName(key), min, max);
    }

    public Set<byte[]> rangeByScore(String key, String min, String max, long offset, long count) {
        return super.rangeByScore((Object)this.getKeyName(key), min, max, offset, count);
    }

    @Override
    public String getKeyName(String key) {
        return this.keyNamingPolicy.getKeyName(key);
    }
}

