/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.data.redis.callback.SessionCallbackX;
import org.openingo.spring.extension.data.redis.commands.IRedisCommands;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultSessionCallback;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisTemplateX<K, V>
implements IRedisCommands<K, V> {
    @Autowired
    protected RedisTemplate<K, V> redisTemplate;

    public ClusterOperations<K, V> opsForCluster() {
        return this.redisTemplate.opsForCluster();
    }

    public GeoOperations<K, V> opsForGeo() {
        return this.redisTemplate.opsForGeo();
    }

    public BoundGeoOperations<K, V> boundGeoOps(K key) {
        return this.redisTemplate.boundGeoOps(key);
    }

    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return this.redisTemplate.boundHashOps(key);
    }

    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public HyperLogLogOperations<K, V> opsForHyperLogLog() {
        return this.redisTemplate.opsForHyperLogLog();
    }

    public ListOperations<K, V> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public BoundListOperations<K, V> boundListOps(K key) {
        return this.redisTemplate.boundListOps(key);
    }

    public BoundSetOperations<K, V> boundSetOps(K key) {
        return this.redisTemplate.boundSetOps(key);
    }

    public SetOperations<K, V> opsForSet() {
        return this.redisTemplate.opsForSet();
    }

    public BoundValueOperations<K, V> boundValueOps(K key) {
        return this.redisTemplate.boundValueOps(key);
    }

    public ValueOperations<K, V> opsForValue() {
        return this.redisTemplate.opsForValue();
    }

    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return this.redisTemplate.boundZSetOps(key);
    }

    public ZSetOperations<K, V> opsForZSet() {
        return this.redisTemplate.opsForZSet();
    }

    public RedisTemplate<K, V> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setEnableTransactionSupport(Boolean enableTransactionSupport) {
        this.redisTemplate.setEnableTransactionSupport(enableTransactionSupport.booleanValue());
    }

    @Override
    public void set(K key, V value) {
        this.opsForValue().set(key, value);
    }

    @Override
    public void setEx(K key, long timeoutSeconds, V value) {
        this.opsForValue().set(key, value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void setEx(K key, long timeout, V value, TimeUnit unit) {
        this.opsForValue().set(key, value, timeout, unit);
    }

    @Override
    public Boolean setNx(K key, V value) {
        return this.opsForValue().setIfAbsent(key, value);
    }

    @Override
    public Boolean setNx(K key, V value, long timeoutSeconds) {
        return this.opsForValue().setIfAbsent(key, value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean setNx(K key, V value, long timeout, TimeUnit unit) {
        return this.opsForValue().setIfAbsent(key, value, timeout, unit);
    }

    @Override
    public Boolean setXx(K key, V value) {
        return this.opsForValue().setIfPresent(key, value);
    }

    @Override
    public Boolean setXx(K key, V value, long timeoutSeconds) {
        return this.opsForValue().setIfPresent(key, value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean setXx(K key, V value, long timeout, TimeUnit unit) {
        return this.opsForValue().setIfPresent(key, value, timeout, unit);
    }

    @Override
    public V get(K key) {
        return (V)this.opsForValue().get(key);
    }

    @Override
    public Boolean del(K key) {
        return this.opsForValue().getOperations().delete(key);
    }

    @Override
    public Long del(Collection<K> keys) {
        return this.opsForValue().getOperations().delete(keys);
    }

    @Override
    public void mSet(Object ... keysValues) {
        int length = keysValues.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        List keys = ListKit.emptyArrayList((int)(length / 2));
        List values = ListKit.emptyArrayList((int)(length / 2));
        for (int i = 0; i < length; ++i) {
            if (i % 2 == 0) {
                keys.add(keysValues[i]);
                continue;
            }
            values.add(keysValues[i]);
        }
        HashMap keysValuesMap = new HashMap(length);
        for (int i = 0; i < keys.size(); ++i) {
            keysValuesMap.put(keys.get(i), values.get(i));
        }
        this.opsForValue().multiSet(keysValuesMap);
    }

    @Override
    public void mSet(Map<K, V> map) {
        this.opsForValue().multiSet(map);
    }

    @Override
    public List<V> mGet(Collection<K> keys) {
        return this.opsForValue().multiGet(keys);
    }

    @Override
    public Long decr(K key) {
        return this.opsForValue().decrement(key);
    }

    @Override
    public Long decrBy(K key, long delta) {
        return this.opsForValue().decrement(key, delta);
    }

    @Override
    public Long incr(K key) {
        return this.opsForValue().increment(key);
    }

    @Override
    public Long incrBy(K key, long delta) {
        return this.opsForValue().increment(key, delta);
    }

    @Override
    public Boolean exists(K key) {
        return this.opsForValue().getOperations().hasKey(key);
    }

    @Override
    public void rename(K oldKey, K newKey) {
        this.opsForValue().getOperations().rename(oldKey, newKey);
    }

    @Override
    public Boolean expire(K key, long timeoutSeconds) {
        return this.opsForValue().getOperations().expire(key, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean expireAt(K key, Date date) {
        return this.opsForValue().getOperations().expireAt(key, date);
    }

    @Override
    public Boolean pExpire(K key, long millTimeoutSeconds) {
        return this.opsForValue().getOperations().expire(key, millTimeoutSeconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public V getSet(K key, V value) {
        return (V)this.opsForValue().getAndSet(key, value);
    }

    @Override
    public Boolean persist(K key) {
        return this.opsForValue().getOperations().persist(key);
    }

    @Override
    public DataType type(K key) {
        return this.opsForValue().getOperations().type(key);
    }

    @Override
    public Long ttl(K key) {
        return this.opsForValue().getOperations().getExpire(key);
    }

    @Override
    public Long countExistingKeys(Collection<K> keys) {
        return this.opsForValue().getOperations().countExistingKeys(keys);
    }

    @Override
    public Integer append(K key, String value) {
        return this.opsForValue().append(key, value);
    }

    @Override
    public String getRange(K key, long start, long end) {
        return this.opsForValue().get(key, start, end);
    }

    @Override
    public void setRange(K key, V value, long offset) {
        this.opsForValue().set(key, value, offset);
    }

    @Override
    public Long strLen(K key) {
        return this.opsForValue().size(key);
    }

    @Override
    public Boolean setBit(K key, long offset, boolean value) {
        return this.opsForValue().setBit(key, offset, value);
    }

    @Override
    public Boolean getBit(K key, long offset) {
        return this.opsForValue().getBit(key, offset);
    }

    @Override
    public List<Long> bitField(K key, BitFieldSubCommands subCommands) {
        return this.opsForValue().bitField(key, subCommands);
    }

    @Override
    public void hSet(K key, Object hashKey, Object value) {
        this.opsForHash().put(key, hashKey, value);
    }

    @Override
    public void hmset(K key, Map<Object, Object> m) {
        this.opsForHash().putAll(key, m);
    }

    @Override
    public <T> T hGet(K key, Object hashKey) {
        return (T)this.opsForHash().get(key, hashKey);
    }

    @Override
    public <T> List<T> hMget(K key, Collection<Object> hashKeys) {
        return new ArrayList(this.opsForHash().multiGet(key, hashKeys));
    }

    @Override
    public Long hDel(K key, Object ... hashKeys) {
        return this.opsForHash().delete(key, hashKeys);
    }

    @Override
    public Boolean hExists(K key, Object hashKey) {
        return this.opsForHash().hasKey(key, hashKey);
    }

    @Override
    public <HK, HV> Map<HK, HV> hGetAll(K key) {
        return new HashMap(this.opsForHash().entries(key));
    }

    @Override
    public <HV> List<HV> hVals(K key) {
        return new ArrayList(this.opsForHash().values(key));
    }

    @Override
    public <HK> Set<HK> hKeys(K key) {
        return new HashSet(this.opsForHash().keys(key));
    }

    @Override
    public Long hLen(K key) {
        return this.opsForHash().size(key);
    }

    @Override
    public V lIndex(K key, long index) {
        return (V)this.opsForList().index(key, index);
    }

    @Override
    public Long lLen(K key) {
        return this.opsForList().size(key);
    }

    @Override
    public V lPop(K key) {
        return (V)this.opsForList().leftPop(key);
    }

    @Override
    public Long lPush(K key, V value) {
        return this.opsForList().leftPush(key, value);
    }

    @Override
    public Long lPush(K key, V ... values) {
        return this.opsForList().leftPushAll(key, (Object[])values);
    }

    @Override
    public Long lPush(K key, Collection<V> values) {
        return this.opsForList().leftPushAll(key, values);
    }

    @Override
    public Long lPushx(K key, V value) {
        return this.opsForList().leftPushIfPresent(key, value);
    }

    @Override
    public void lSet(K key, long index, V value) {
        this.opsForList().set(key, index, value);
    }

    @Override
    public Long lRem(K key, long count, V value) {
        return this.opsForList().remove(key, count, value);
    }

    @Override
    public List<V> lRange(K key, long start, long end) {
        return this.opsForList().range(key, start, end);
    }

    @Override
    public void ltrim(K key, long start, long end) {
        this.opsForList().trim(key, start, end);
    }

    @Override
    public V rPop(K key) {
        return (V)this.opsForList().rightPop(key);
    }

    @Override
    public V rPoplPush(K srcKey, K dstKey) {
        return (V)this.opsForList().rightPopAndLeftPush(srcKey, dstKey);
    }

    @Override
    public V brPoplPush(K srcKey, K dstKey, long timeoutSeconds) {
        return (V)this.opsForList().rightPopAndLeftPush(srcKey, dstKey, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Long rPush(K key, V value) {
        return this.opsForList().rightPush(key, value);
    }

    @Override
    public Long rPush(K key, V ... values) {
        return this.opsForList().rightPushAll(key, (Object[])values);
    }

    @Override
    public Long rPush(K key, Collection<V> values) {
        return this.opsForList().rightPushAll(key, values);
    }

    @Override
    public Long rPushx(K key, V value) {
        return this.opsForList().rightPushIfPresent(key, value);
    }

    @Override
    public V blPop(K key, long timeoutSeconds) {
        return (V)this.opsForList().leftPop(key, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public V brPop(K key, long timeoutSeconds) {
        return (V)this.opsForList().rightPop(key, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Long sAdd(K key, V ... values) {
        return this.opsForSet().add(key, (Object[])values);
    }

    @Override
    public Long sCard(K key) {
        return this.opsForSet().size(key);
    }

    @Override
    public V sPop(K key) {
        return (V)this.opsForSet().pop(key);
    }

    @Override
    public Set<V> sMembers(K key) {
        return this.opsForSet().members(key);
    }

    @Override
    public Boolean sIsMember(K key, Object member) {
        return this.opsForSet().isMember(key, member);
    }

    @Override
    public Set<V> sInter(K key, K otherKey) {
        return this.opsForSet().intersect(key, otherKey);
    }

    @Override
    public Set<V> sInter(K key, Collection<K> otherKeys) {
        return this.opsForSet().intersect(key, otherKeys);
    }

    @Override
    public Long sInterstore(K key, K otherKey, K destKey) {
        return this.opsForSet().intersectAndStore(key, otherKey, destKey);
    }

    @Override
    public Long sInterStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().intersectAndStore(key, otherKeys, destKey);
    }

    @Override
    public V sRandMember(K key) {
        return (V)this.opsForSet().randomMember(key);
    }

    @Override
    public List<V> sRandMember(K key, long count) {
        return this.opsForSet().randomMembers(key, count);
    }

    @Override
    public Long sRem(K key, Object ... members) {
        return this.opsForSet().remove(key, members);
    }

    @Override
    public Set<V> sUnion(K key, K otherKey) {
        return this.opsForSet().union(key, otherKey);
    }

    @Override
    public Set<V> sUnion(K key, Collection<K> otherKeys) {
        return this.opsForSet().union(key, otherKeys);
    }

    @Override
    public Long sUnionStore(K key, K otherKey, K destKey) {
        return this.opsForSet().unionAndStore(key, otherKey, destKey);
    }

    @Override
    public Long sUnionStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().unionAndStore(key, otherKeys, destKey);
    }

    @Override
    public Set<V> sDiff(K key, K otherKey) {
        return this.opsForSet().difference(key, otherKey);
    }

    @Override
    public Set<V> sDiff(K key, Collection<K> otherKeys) {
        return this.opsForSet().difference(key, otherKeys);
    }

    @Override
    public Long sDiffStore(K key, K otherKey, K destKey) {
        return this.opsForSet().differenceAndStore(key, otherKey, destKey);
    }

    @Override
    public Long sDiffStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().differenceAndStore(key, otherKeys, destKey);
    }

    @Override
    public Boolean zAdd(K key, V member, double score) {
        return this.opsForZSet().add(key, member, score);
    }

    @Override
    public Long zAdd(K key, Map<V, Double> scoreMembers) {
        if (ValidateKit.isNull(scoreMembers)) {
            return 0L;
        }
        HashSet tuples = new HashSet();
        scoreMembers.forEach((k, score) -> tuples.add(new DefaultTypedTuple(k, score)));
        return this.opsForZSet().add(key, tuples);
    }

    @Override
    public Long zCard(K key) {
        return this.opsForZSet().size(key);
    }

    @Override
    public Long zCount(K key, double min, double max) {
        return this.opsForZSet().count(key, min, max);
    }

    @Override
    public Double zIncrby(K key, V member, double score) {
        return this.opsForZSet().incrementScore(key, member, score);
    }

    @Override
    public Set<V> zRange(K key, long start, long end) {
        return this.opsForZSet().range(key, start, end);
    }

    @Override
    public Set<V> zRevRange(K key, long start, long end) {
        return this.opsForZSet().reverseRange(key, start, end);
    }

    @Override
    public Set<V> zRangeByScore(K key, double min, double max) {
        return this.opsForZSet().rangeByScore(key, min, max);
    }

    @Override
    public Long zRank(K key, Object member) {
        return this.opsForZSet().rank(key, member);
    }

    @Override
    public Long zRevRank(K key, Object member) {
        return this.opsForZSet().reverseRank(key, member);
    }

    @Override
    public Long zRem(K key, Object ... members) {
        return this.opsForZSet().remove(key, members);
    }

    @Override
    public Double zScore(K key, Object member) {
        return this.opsForZSet().score(key, member);
    }

    @Override
    public Set<V> zRangeByScore(K key, double min, double max, long offset, long count) {
        return this.opsForZSet().rangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<V> zRevRange(K key, double min, double max) {
        return this.opsForZSet().reverseRangeByScore(key, min, max);
    }

    @Override
    public Set<V> zRevRangeByScore(K key, double min, double max, long offset, long count) {
        return this.opsForZSet().reverseRangeByScore(key, min, max, offset, count);
    }

    @Override
    public Long zRemRangeByRank(K key, long start, long end) {
        return this.opsForZSet().removeRange(key, start, end);
    }

    @Override
    public Long zRemRangeByScore(K key, double min, double max) {
        return this.opsForZSet().removeRangeByScore(key, min, max);
    }

    @Override
    public Long zUnionStore(K key, K otherKey, K destKey) {
        return this.opsForZSet().unionAndStore(key, otherKey, destKey);
    }

    @Override
    public Long zUnionStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForZSet().unionAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long zUnionStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return this.opsForZSet().unionAndStore(key, otherKeys, destKey, aggregate, weights);
    }

    @Override
    public Long zInterStore(K key, K otherKey, K destKey) {
        return this.opsForZSet().intersectAndStore(key, otherKey, destKey);
    }

    @Override
    public Long zInterStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForZSet().intersectAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long zInterStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return this.opsForZSet().intersectAndStore(key, otherKeys, destKey, aggregate, weights);
    }

    @Override
    public Cursor<ZSetOperations.TypedTuple<V>> zScan(K key, ScanOptions options) {
        return this.opsForZSet().scan(key, options);
    }

    @Override
    public Set<V> zRangeByLex(K key, RedisZSetCommands.Range range) {
        return this.opsForZSet().rangeByLex(key, range);
    }

    @Override
    public Set<V> zRangeByLex(K key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.opsForZSet().rangeByLex(key, range, limit);
    }

    @Override
    public Long geoAdd(K key, Point point, V member) {
        return this.opsForGeo().add(key, point, member);
    }

    @Override
    public Long geoAdd(K key, RedisGeoCommands.GeoLocation<V> location) {
        return this.opsForGeo().add(key, location);
    }

    @Override
    public Long geoAdd(K key, Map<V, Point> memberCoordinateMap) {
        return this.opsForGeo().add(key, memberCoordinateMap);
    }

    @Override
    public Long geoAdd(K key, Iterable<RedisGeoCommands.GeoLocation<V>> geoLocations) {
        return this.opsForGeo().add(key, geoLocations);
    }

    @Override
    public Distance geoDist(K key, V member1, V member2) {
        return this.opsForGeo().distance(key, member1, member2);
    }

    @Override
    public Distance geoDist(K key, V member1, V member2, Metric metric) {
        return this.opsForGeo().distance(key, member1, member2, metric);
    }

    @Override
    public List<String> geoHash(K key, V ... members) {
        return this.opsForGeo().hash(key, (Object[])members);
    }

    @Override
    public List<Point> geoPos(K key, V ... members) {
        return this.opsForGeo().position(key, (Object[])members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadius(K key, Circle within) {
        return this.opsForGeo().radius(key, within);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.opsForGeo().radius(key, within, args);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, double radius) {
        return this.opsForGeo().radius(key, member, radius);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, Distance distance) {
        return this.opsForGeo().radius(key, member, distance);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.opsForGeo().radius(key, member, distance, args);
    }

    @Override
    public Long geoRemove(K key, V ... members) {
        return this.opsForGeo().remove(key, (Object[])members);
    }

    @Override
    public Long pfAdd(K key, V ... values) {
        return this.opsForHyperLogLog().add(key, (Object[])values);
    }

    @Override
    public Long pfCount(K ... keys) {
        return this.opsForHyperLogLog().size((Object[])keys);
    }

    @Override
    public Long pfMerge(K destination, K ... sourceKeys) {
        return this.opsForHyperLogLog().union(destination, (Object[])sourceKeys);
    }

    @Override
    public Boolean unlink(K key) {
        return this.redisTemplate.unlink(key);
    }

    @Override
    public Long unlink(Collection<K> keys) {
        return this.redisTemplate.unlink(keys);
    }

    @Override
    public Boolean move(K key, int dbIndex) {
        return this.redisTemplate.move(key, dbIndex);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.redisTemplate.sort(query);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, RedisSerializer<T> resultSerializer) {
        return this.redisTemplate.sort(query, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.redisTemplate.sort(query, bulkMapper);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
        return this.redisTemplate.sort(query, bulkMapper, resultSerializer);
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        return this.redisTemplate.sort(query, storeKey);
    }

    @Override
    public <T> T execute(SessionCallbackX session) {
        DefaultSessionCallback defaultSessionCallback = new DefaultSessionCallback(session);
        return (T)this.redisTemplate.execute(defaultSessionCallback);
    }

    @Override
    public List<Object> executePipelined(SessionCallbackX session) {
        DefaultSessionCallback defaultSessionCallback = new DefaultSessionCallback(session);
        return this.redisTemplate.executePipelined(defaultSessionCallback);
    }

    @Override
    public List<Object> executePipelined(SessionCallbackX session, RedisSerializer<?> resultSerializer) {
        DefaultSessionCallback defaultSessionCallback = new DefaultSessionCallback(session);
        return this.redisTemplate.executePipelined(defaultSessionCallback, resultSerializer);
    }

    @Override
    public void watch(K key) {
        this.redisTemplate.watch(key);
    }

    @Override
    public void watch(Collection<K> keys) {
        this.redisTemplate.watch(keys);
    }

    @Override
    public void unwatch() {
        this.redisTemplate.unwatch();
    }

    @Override
    public void multi() {
        this.redisTemplate.multi();
    }

    @Override
    public void discard() {
        this.redisTemplate.discard();
    }

    @Override
    public List<Object> exec() {
        return this.redisTemplate.exec();
    }

    @Override
    public List<Object> exec(RedisSerializer<?> valueSerializer) {
        return this.redisTemplate.exec(valueSerializer);
    }
}

