/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openingo.spring.extension.data.redis.RedisTemplateX;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.DefaultBoundGeoOperationsX;
import org.springframework.data.redis.core.DefaultBoundListOperationsX;
import org.springframework.data.redis.core.DefaultBoundOperationsX;
import org.springframework.data.redis.core.DefaultBoundSetOperationsX;
import org.springframework.data.redis.core.DefaultBoundValueOperationsX;
import org.springframework.data.redis.core.DefaultBoundZSetOperationsX;
import org.springframework.data.redis.core.DefaultClusterOperationsX;
import org.springframework.data.redis.core.DefaultGeoOperationsX;
import org.springframework.data.redis.core.DefaultHashOperationsX;
import org.springframework.data.redis.core.DefaultHyperLogLogOperationsX;
import org.springframework.data.redis.core.DefaultListOperationsX;
import org.springframework.data.redis.core.DefaultSetOperationsX;
import org.springframework.data.redis.core.DefaultValueOperationsX;
import org.springframework.data.redis.core.DefaultZSetOperationsX;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.DefaultStringSortQuery;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public class StringKeyRedisTemplateX<V>
extends RedisTemplateX<String, V> {
    @Nullable
    private ValueOperations<String, V> valueOps;
    @Nullable
    private ListOperations<String, V> listOps;
    @Nullable
    private SetOperations<String, V> setOps;
    @Nullable
    private ZSetOperations<String, V> zSetOps;
    @Nullable
    private GeoOperations<String, V> geoOps;
    @Nullable
    private HyperLogLogOperations<String, V> hllOps;
    @Autowired
    private IKeyNamingPolicy keyNamingPolicy;

    @Override
    public ClusterOperations<String, V> opsForCluster() {
        return new DefaultClusterOperationsX(this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public GeoOperations<String, V> opsForGeo() {
        if (this.geoOps == null) {
            this.geoOps = new DefaultGeoOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.geoOps;
    }

    @Override
    public BoundGeoOperations<String, V> boundGeoOps(String key) {
        return new DefaultBoundGeoOperationsX(key, this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public <HK, HV> BoundHashOperations<String, HK, HV> boundHashOps(String key) {
        return new DefaultBoundOperationsX(key, (RedisOperations<String, ?>)this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public <HK, HV> HashOperations<String, HK, HV> opsForHash() {
        return new DefaultHashOperationsX(this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public HyperLogLogOperations<String, V> opsForHyperLogLog() {
        if (this.hllOps == null) {
            this.hllOps = new DefaultHyperLogLogOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.hllOps;
    }

    @Override
    public ListOperations<String, V> opsForList() {
        if (this.listOps == null) {
            this.listOps = new DefaultListOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.listOps;
    }

    @Override
    public BoundListOperations<String, V> boundListOps(String key) {
        return new DefaultBoundListOperationsX(key, this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public BoundSetOperations<String, V> boundSetOps(String key) {
        return new DefaultBoundSetOperationsX(key, this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public SetOperations<String, V> opsForSet() {
        if (this.setOps == null) {
            this.setOps = new DefaultSetOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.setOps;
    }

    @Override
    public BoundValueOperations<String, V> boundValueOps(String key) {
        return new DefaultBoundValueOperationsX(key, this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public ValueOperations<String, V> opsForValue() {
        if (this.valueOps == null) {
            this.valueOps = new DefaultValueOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.valueOps;
    }

    @Override
    public BoundZSetOperations<String, V> boundZSetOps(String key) {
        return new DefaultBoundZSetOperationsX(key, this.redisTemplate, this.keyNamingPolicy);
    }

    @Override
    public ZSetOperations<String, V> opsForZSet() {
        if (this.zSetOps == null) {
            this.zSetOps = new DefaultZSetOperationsX(this.redisTemplate, this.keyNamingPolicy);
        }
        return this.zSetOps;
    }

    @Override
    public Boolean del(String key) {
        return super.del(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public Long del(Collection<String> keys) {
        return super.del(this.keyNamingPolicy.getKeyNames(keys));
    }

    @Override
    public Boolean exists(String key) {
        return super.exists(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public void rename(String oldKey, String newKey) {
        super.rename(this.keyNamingPolicy.getKeyName(oldKey), this.keyNamingPolicy.getKeyName(newKey));
    }

    @Override
    public Boolean expire(String key, long timeoutSeconds) {
        return super.expire(this.keyNamingPolicy.getKeyName(key), timeoutSeconds);
    }

    @Override
    public Boolean expireAt(String key, Date date) {
        return super.expireAt(this.keyNamingPolicy.getKeyName(key), date);
    }

    @Override
    public Boolean pExpire(String key, long millTimeoutSeconds) {
        return super.pExpire(this.keyNamingPolicy.getKeyName(key), millTimeoutSeconds);
    }

    @Override
    public Boolean persist(String key) {
        return super.persist(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public DataType type(String key) {
        return super.type(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public Long ttl(String key) {
        return super.ttl(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public Long countExistingKeys(Collection<String> keys) {
        return super.countExistingKeys(this.keyNamingPolicy.getKeyNames(keys));
    }

    @Override
    public Boolean unlink(String key) {
        return super.unlink(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public Long unlink(Collection<String> keys) {
        return super.unlink(this.keyNamingPolicy.getKeyNames(keys));
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        return super.move(this.keyNamingPolicy.getKeyName(key), dbIndex);
    }

    @Override
    public List<V> sort(SortQuery<String> query) {
        DefaultStringSortQuery sortQuery = new DefaultStringSortQuery(this.keyNamingPolicy, query);
        return super.sort(sortQuery);
    }

    @Override
    public <T> List<T> sort(SortQuery<String> query, RedisSerializer<T> resultSerializer) {
        DefaultStringSortQuery sortQuery = new DefaultStringSortQuery(this.keyNamingPolicy, query);
        return super.sort(sortQuery, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<String> query, BulkMapper<T, V> bulkMapper) {
        DefaultStringSortQuery sortQuery = new DefaultStringSortQuery(this.keyNamingPolicy, query);
        return super.sort(sortQuery, bulkMapper);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<String> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
        DefaultStringSortQuery sortQuery = new DefaultStringSortQuery(this.keyNamingPolicy, query);
        return super.sort(sortQuery, bulkMapper, resultSerializer);
    }

    @Override
    public Long sort(SortQuery<String> query, String storeKey) {
        DefaultStringSortQuery sortQuery = new DefaultStringSortQuery(this.keyNamingPolicy, query);
        return super.sort(sortQuery, this.keyNamingPolicy.getKeyName(storeKey));
    }

    @Override
    public void watch(String key) {
        super.watch(this.keyNamingPolicy.getKeyName(key));
    }

    @Override
    public void watch(Collection<String> keys) {
        super.watch(this.keyNamingPolicy.getKeyNames(keys));
    }
}

