/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.feign.config;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.feign.hystrix.FeignHystrixConcurrencyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@ConditionalOnClass(value={RequestInterceptor.class})
public class FeignConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignConfig.class);

    @Bean
    public RequestInterceptor requestHeadersCoverInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (ValidateKit.isNull((Object)attrs)) {
                return;
            }
            HttpServletRequest request = attrs.getRequest();
            if (ValidateKit.isNull((Object)request)) {
                return;
            }
            Enumeration requestHeaderNames = request.getHeaderNames();
            if (ValidateKit.isNull((Object)requestHeaderNames)) {
                return;
            }
            Map requestTemplateHeaders = requestTemplate.headers();
            List lowerCaseRequestTemplateHeaders = requestTemplateHeaders.keySet().stream().map(String::toLowerCase).distinct().collect(Collectors.toList());
            while (requestHeaderNames.hasMoreElements()) {
                String name = (String)requestHeaderNames.nextElement();
                String value = request.getHeader(name);
                Collection values = (Collection)requestTemplateHeaders.get(name);
                values = Optional.of(new ArrayList(values)).orElse(new ArrayList());
                if (!lowerCaseRequestTemplateHeaders.contains(name.toLowerCase())) {
                    values.add(value);
                    requestTemplateHeaders.put(name, values);
                    continue;
                }
                values.add(value);
            }
            requestTemplate.headers(null);
            requestTemplate.headers(requestTemplateHeaders);
        };
    }

    @Bean
    @ConditionalOnClass(value={HystrixConcurrencyStrategy.class})
    public FeignHystrixConcurrencyStrategy feignHystrixConcurrencyStrategy() {
        return new FeignHystrixConcurrencyStrategy();
    }
}

