/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.http.config;

import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.http.config.HttpConfigProperties;
import org.openingo.spring.http.mvc.HttpWebMvcConfigurer;
import org.openingo.spring.http.request.HttpRequestLogAspect;
import org.openingo.spring.http.request.error.DefaultServiceErrorAttributes;
import org.openingo.spring.http.response.HttpResponseBodyAdvice;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.View;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
public class HttpConfig {
    @Bean
    @ConditionalOnProperty(prefix="openingo.http.request.log", name={"enable"}, havingValue="true", matchIfMissing=true)
    public HttpRequestLogAspect httpRequestLogAspect() {
        return new HttpRequestLogAspect();
    }

    @Bean
    @ConditionalOnProperty(prefix="openingo.http.request.cors", name={"enable"}, havingValue="true")
    @ConditionalOnMissingBean
    public CorsFilter corsFilter(HttpConfigProperties.HttpRequestCorsConfigProperties corsConfigProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        String allowedOrigin = corsConfigProperties.getAllowedOrigin();
        String allowedHeader = corsConfigProperties.getAllowedHeader();
        String allowedMethod = corsConfigProperties.getAllowedMethod();
        if (corsConfigProperties.isAllowedAll()) {
            allowedOrigin = "*";
            allowedHeader = "*";
            allowedMethod = "*";
        }
        if (ValidateKit.isNotNull((Object)allowedOrigin)) {
            corsConfiguration.addAllowedOrigin(allowedOrigin);
        }
        if (ValidateKit.isNotNull((Object)allowedHeader)) {
            corsConfiguration.addAllowedHeader(allowedHeader);
        }
        if (ValidateKit.isNotNull((Object)allowedMethod)) {
            corsConfiguration.addAllowedMethod(allowedMethod);
        }
        corsConfiguration.setAllowCredentials(Boolean.valueOf(corsConfigProperties.isAllowCredentials()));
        String path = corsConfigProperties.getPath();
        if (ValidateKit.isNotNull((Object)path)) {
            source.registerCorsConfiguration(path, corsConfiguration);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public HttpWebMvcConfigurer httpWebMvcConfigurer() {
        return new HttpWebMvcConfigurer();
    }

    @ControllerAdvice
    @Order(value=-100)
    static class HttpControllerAdvice
    extends HttpResponseBodyAdvice {
        HttpControllerAdvice() {
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="openingo.http.request.error", name={"enable"}, havingValue="true", matchIfMissing=true)
    static class HttpErrorConfig {
        HttpErrorConfig() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
        public DefaultServiceErrorAttributes serviceDefaultErrorAttributes() {
            return new DefaultServiceErrorAttributes();
        }

        @Bean(name={"error"})
        @ConditionalOnMissingBean(name={"error"})
        public View defaultErrorView() {
            return new StaticErrorView();
        }

        static class StaticErrorView
        implements View {
            private static final Log logger = LogFactory.getLog(StaticErrorView.class);

            StaticErrorView() {
            }

            public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                if (response.isCommitted()) {
                    String message = this.getMessage(model);
                    logger.error((Object)message);
                    return;
                }
                StringBuilder builder = new StringBuilder();
                if (response.getContentType() == null) {
                    response.setContentType(this.getContentType());
                }
                builder.append("<html><body><h1> :: SpringApplicationX :: Whitelabel Error Page</h1>");
                builder.append("<h3>Error Details:</h3>");
                model.forEach((k, v) -> builder.append("<div> ").append((String)k).append(" => \"").append(v).append("\" </div>"));
                builder.append("</body></html>");
                response.getWriter().append(builder.toString());
            }

            private String getMessage(Map<String, ?> model) {
                Object path = model.get("path");
                String message = "Cannot render error page for request [" + path + "]";
                Object mMessage = model.get("message");
                if (ValidateKit.isNotNull(mMessage)) {
                    message = message + " and exception [" + mMessage + "]";
                }
                message = message + " as the response has already been committed.";
                message = message + " As a result, the response may have the wrong status code.";
                return message;
            }

            public String getContentType() {
                return "text/html";
            }
        }
    }
}

