/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.http.request.error;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.openingo.jdkits.http.RespData;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.exception.ServiceException;
import org.openingo.spring.extension.http.config.HttpConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributesX;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractServiceErrorAttributes
extends DefaultErrorAttributesX {
    @Autowired
    HttpConfigProperties.HttpRequestErrorConfigProperties httpRequestErrorConfigProperties;

    public AbstractServiceErrorAttributes() {
        super(true);
    }

    @Override
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map<String, Object> errorAttributes = super.getErrorAttributes(webRequest, includeStackTrace);
        if (!this.httpRequestErrorConfigProperties.isEnable()) {
            return errorAttributes;
        }
        Object code = null;
        String message = null;
        Exception exception = this.getHandlerExecutionException();
        HashMap<String, Object> serviceErrorAttributes = new HashMap<String, Object>();
        if (!this.responseOK(errorAttributes) && ValidateKit.isNotNull((Object)exception)) {
            if (exception instanceof ServiceException) {
                code = ((ServiceException)exception).getExceptionCode();
                message = exception.getMessage();
            }
            code = ValidateKit.isNull(code) ? this.decorateExceptionCode(exception) : code;
            String string = message = ValidateKit.isNull((Object)message) ? this.decorateExceptionMessage0(exception) : message;
        }
        if (!RespData.Config.SM_ONLY) {
            code = ValidateKit.isNull(code) ? this.getStatus(errorAttributes) : code;
            code = RespData.Config.FAILURE_SC instanceof String ? code.toString() : code;
            serviceErrorAttributes.put(RespData.Config.SC_KEY, code);
        }
        message = ValidateKit.isNull(message) ? this.getError(errorAttributes) : message;
        serviceErrorAttributes.put(RespData.Config.SM_KEY, message);
        this.decorateErrorAttributes(errorAttributes, serviceErrorAttributes);
        return serviceErrorAttributes;
    }

    private String decorateExceptionMessage0(Exception exception) {
        String friendlyFailureMessage = RespData.Config.FRIENDLY_FAILURE_MESSAGE;
        if (ValidateKit.isNotNull((Object)friendlyFailureMessage)) {
            return friendlyFailureMessage;
        }
        if (exception instanceof MethodArgumentNotValidException) {
            return this.getErrorMessage(((MethodArgumentNotValidException)exception).getBindingResult());
        }
        if (exception instanceof BindException) {
            return this.getErrorMessage(((BindException)exception).getBindingResult());
        }
        if (exception instanceof ConstraintViolationException) {
            Optional first = ((ConstraintViolationException)((Object)exception)).getConstraintViolations().stream().findFirst();
            return first.map(ConstraintViolation::getMessage).get();
        }
        return this.decorateExceptionMessage(exception);
    }

    private String getErrorMessage(BindingResult bindingResult) {
        List errors = bindingResult.getFieldErrors();
        return ((FieldError)errors.get(0)).getDefaultMessage();
    }

    public abstract String decorateExceptionMessage(Exception var1);

    public abstract Object decorateExceptionCode(Exception var1);

    public abstract void decorateErrorAttributes(Map<String, Object> var1, Map<String, Object> var2);
}

