/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.validator;

import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;

public interface DynamicValidator {
    public void dynamicValidate();

    default public String silentDynamicValidate() {
        String errorMessage;
        block2: {
            errorMessage = null;
            try {
                this.dynamicValidate();
            }
            catch (ConstraintViolationException ex) {
                Set constraintViolations = ex.getConstraintViolations();
                errorMessage = ex.getMessage();
                if (null == constraintViolations || constraintViolations.size() <= 0) break block2;
                Optional first = constraintViolations.stream().findFirst();
                errorMessage = first.map(ConstraintViolation::getMessage).get();
            }
        }
        return errorMessage;
    }

    default public void validateField(boolean inValid, String defaultMessage) {
        if (inValid) {
            this.throwValidationException(defaultMessage);
        }
    }

    default public <T> void validateSelf(T data, Class<?> ... groups) {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set validate = validator.validate(data, (Class[])groups);
        this.parserValidateRet(validate);
    }

    default public <T extends DynamicValidator> void dynamicValidate(T data, String errorMessage, Class<?> ... groups) {
        if (null == data) {
            this.throwValidationException(errorMessage);
            return;
        }
        this.validateSelf(data, groups);
        data.dynamicValidate();
    }

    default public void throwValidationException(String message) {
        throw new ConstraintViolationException(message, null);
    }

    default public <T> void parserValidateRet(Set<ConstraintViolation<T>> validate) {
        if (null != validate && validate.size() > 0) {
            throw new ConstraintViolationException(validate);
        }
    }

    default public void addConstraintViolation(ConstraintValidatorContext context, String messageTemplate) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(messageTemplate).addConstraintViolation();
    }
}

