/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.datasource.provider;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.openingo.spring.datasource.provider.IDataSourceProvider;

public class HikariDataSourceProvider
extends HikariDataSource
implements IDataSourceProvider {
    private volatile boolean isStarted = false;

    public HikariDataSourceProvider(HikariDataSource dataSource) {
        super((HikariConfig)dataSource);
    }

    public HikariDataSourceProvider(String jdbcUrl, String username, String password) {
        super.setJdbcUrl(jdbcUrl);
        super.setUsername(username);
        super.setPassword(password);
    }

    public HikariDataSourceProvider(String jdbcUrl, String username, String password, String driverClassName) {
        this(jdbcUrl, username, password);
        super.setDriverClassName(driverClassName);
    }

    @Override
    public DataSource getDataSource() {
        return this;
    }

    @Override
    public final String getProviderName() {
        return this.getPoolName();
    }

    @Override
    public boolean startProviding() {
        if (this.isStarted) {
            return true;
        }
        String jdbcUrl = super.getJdbcUrl().toLowerCase();
        if (jdbcUrl.contains(":mysql:")) {
            super.addDataSourceProperty("cachePrepStmts", (Object)"true");
            super.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            super.addDataSourceProperty("prepStmtCacheSize", (Object)"256");
            super.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        }
        if (jdbcUrl.contains(":postgresql:")) {
            super.setConnectionTimeout(0L);
            super.addDataSourceProperty("prepareThreshold", (Object)"3");
            super.addDataSourceProperty("preparedStatementCacheQueries", (Object)"128");
            super.addDataSourceProperty("preparedStatementCacheSizeMiB", (Object)"4");
        }
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean destroy() {
        this.close();
        this.isStarted = false;
        return true;
    }
}

