/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis.core.query;

import java.util.List;
import java.util.stream.Collectors;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.SortQuery;

public class DefaultStringSortQuery
implements SortQuery<String> {
    IKeyNamingPolicy keyNamingPolicy;
    String originKey;
    SortQuery<String> origin;

    public DefaultStringSortQuery(IKeyNamingPolicy keyNamingPolicy, SortQuery<String> origin) {
        this.keyNamingPolicy = keyNamingPolicy;
        this.origin = origin;
        this.originKey = (String)origin.getKey();
    }

    public String getKey() {
        return this.keyNamingPolicy.getKeyName(this.originKey);
    }

    public SortParameters.Order getOrder() {
        return this.origin.getOrder();
    }

    public Boolean isAlphabetic() {
        return this.origin.isAlphabetic();
    }

    public SortParameters.Range getLimit() {
        return this.origin.getLimit();
    }

    public String getBy() {
        return this.keyNamingPolicy.getKeyName(this.origin.getBy());
    }

    public List<String> getGetPattern() {
        return this.origin.getGetPattern().stream().filter(pattern -> pattern.contains(this.originKey)).map(pattern -> pattern.replace(this.originKey, this.keyNamingPolicy.getKeyName(this.originKey))).collect(Collectors.toList());
    }
}

