/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.http.request;

import java.io.File;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.reflect.ClassKit;
import org.openingo.jdkits.sys.IPKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.http.request.ProceedingJoinPointHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.MultipartFile;

public final class HttpRequestReporter {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestReporter.class);
    private HttpServletRequest request;
    private float processingTime = 0.0f;
    private Object responseData = null;
    private ProceedingJoinPoint point;
    private HandlerMethod handler;
    private Exception exception;
    private static int maxOutputLengthOfParaValue = 512;

    private HttpRequestReporter() {
    }

    public static HttpRequestReporter getInstance() {
        return new HttpRequestReporter();
    }

    private Class<?> deduceTargetClass() {
        Class<?> targetClass = null;
        if (ValidateKit.isNotNull((Object)this.point)) {
            targetClass = this.point.getTarget().getClass();
        }
        if (ValidateKit.isNotNull((Object)this.handler)) {
            targetClass = this.handler.getBean().getClass();
        }
        return ClassKit.getUserClass(targetClass);
    }

    private String deduceActionName() {
        if (ValidateKit.isNotNull((Object)this.point)) {
            return this.point.getSignature().getName();
        }
        if (ValidateKit.isNotNull((Object)this.handler)) {
            return this.handler.getMethod().getName();
        }
        return null;
    }

    public Object getBody() {
        Object bodyParam;
        ProceedingJoinPoint proceedingJoinPoint = ProceedingJoinPointHolder.getProceedingJoinPoint();
        if (ValidateKit.isNull((Object)proceedingJoinPoint)) {
            return "Error";
        }
        Object[] joinPointArgs = proceedingJoinPoint.getArgs();
        Stream<Object> stream = ValidateKit.isNull((Object)joinPointArgs) ? Stream.empty() : Arrays.asList(joinPointArgs).stream();
        List bodyParams = stream.filter(arg -> !(arg instanceof HttpServletRequest) && !(arg instanceof HttpServletResponse)).collect(Collectors.toList());
        if (bodyParams.size() > 0 && !((bodyParam = bodyParams.get(0)) instanceof File) && !(bodyParam instanceof MultipartFile)) {
            return bodyParam;
        }
        return "Nothing or A File or Handler(Action) Not Supports body";
    }

    public void report() {
        Enumeration e;
        ServletServerHttpRequest serverHttpRequest = new ServletServerHttpRequest(this.request);
        StringBuilder reportInfoBuilder = new StringBuilder("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\n");
        reportInfoBuilder.append("Client IP  : ").append(IPKit.getRequestIP((HttpServletRequest)this.request)).append(" ").append("\n");
        reportInfoBuilder.append("Request Time  : ").append(LocalDateTime.now()).append(" ").append("\n");
        Class<?> target = this.deduceTargetClass();
        if (ValidateKit.isNotNull(target)) {
            reportInfoBuilder.append("Controller  : ").append(target.getName()).append(".(").append(target.getSimpleName()).append(".java:1)").append("\n");
        }
        reportInfoBuilder.append("URI  : ").append(serverHttpRequest.getURI()).append(" ").append("\n");
        String actionName = this.deduceActionName();
        if (ValidateKit.isNotNull((Object)actionName)) {
            reportInfoBuilder.append("Handler(Action)  : ").append(actionName).append("\n");
        }
        reportInfoBuilder.append("Method  : ").append(serverHttpRequest.getMethod()).append("\n");
        reportInfoBuilder.append("Processing Time  : ").append(this.processingTime).append("s\n");
        reportInfoBuilder.append("Header(s)  : ").append(serverHttpRequest.getHeaders()).append("\n");
        Object body = this.getBody();
        body = ValidateKit.isNotNull((Object)body) ? JacksonKit.toJson((Object)body) : "Nothing or A File";
        reportInfoBuilder.append("Body  : ").append(body).append("\n");
        String urlQuery = this.request.getQueryString();
        if (ValidateKit.isNotNull((Object)urlQuery)) {
            reportInfoBuilder.append("UrlQuery  : ").append(urlQuery).append("\n");
        }
        if ((e = this.request.getParameterNames()).hasMoreElements()) {
            reportInfoBuilder.append("Parameter(s)  : ");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = this.request.getParameterValues(name);
                if (values.length == 1) {
                    reportInfoBuilder.append(name).append("=");
                    if (values[0] != null && values[0].length() > maxOutputLengthOfParaValue) {
                        reportInfoBuilder.append(values[0], 0, maxOutputLengthOfParaValue).append("...");
                    } else {
                        reportInfoBuilder.append(values[0]);
                    }
                } else {
                    reportInfoBuilder.append(name).append("[]={");
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            reportInfoBuilder.append(",");
                        }
                        reportInfoBuilder.append(values[i]);
                    }
                    reportInfoBuilder.append("}");
                }
                reportInfoBuilder.append(", ");
            }
            reportInfoBuilder.append("\n");
        }
        if (ValidateKit.isNotNull((Object)this.responseData)) {
            reportInfoBuilder.append("Response  : ").append(JacksonKit.toJson((Object)this.responseData)).append("\n");
        }
        if (ValidateKit.isNotNull((Object)this.exception)) {
            reportInfoBuilder.append("Exception  : ").append(this.exception.toString()).append("\n");
        }
        reportInfoBuilder.append("----------------------------------------------------------------\n");
        this.report(reportInfoBuilder.toString());
    }

    public void report(String info) {
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info(info);
        } else {
            System.out.println(info);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public float getProcessingTime() {
        return this.processingTime;
    }

    public Object getResponseData() {
        return this.responseData;
    }

    public ProceedingJoinPoint getPoint() {
        return this.point;
    }

    public HandlerMethod getHandler() {
        return this.handler;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setProcessingTime(float processingTime) {
        this.processingTime = processingTime;
    }

    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public void setPoint(ProceedingJoinPoint point) {
        this.point = point;
    }

    public void setHandler(HandlerMethod handler) {
        this.handler = handler;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestReporter)) {
            return false;
        }
        HttpRequestReporter other = (HttpRequestReporter)o;
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        if (Float.compare(this.getProcessingTime(), other.getProcessingTime()) != 0) {
            return false;
        }
        Object this$responseData = this.getResponseData();
        Object other$responseData = other.getResponseData();
        if (this$responseData == null ? other$responseData != null : !this$responseData.equals(other$responseData)) {
            return false;
        }
        ProceedingJoinPoint this$point = this.getPoint();
        ProceedingJoinPoint other$point = other.getPoint();
        if (this$point == null ? other$point != null : !this$point.equals(other$point)) {
            return false;
        }
        HandlerMethod this$handler = this.getHandler();
        HandlerMethod other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getProcessingTime());
        Object $responseData = this.getResponseData();
        result = result * 59 + ($responseData == null ? 43 : $responseData.hashCode());
        ProceedingJoinPoint $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        HandlerMethod $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequestReporter(request=" + this.getRequest() + ", processingTime=" + this.getProcessingTime() + ", responseData=" + this.getResponseData() + ", point=" + this.getPoint() + ", handler=" + this.getHandler() + ", exception=" + this.getException() + ")";
    }
}

