/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.elasticsearch;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortBuilder;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.data.elasticsearch.builder.PageParamBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.util.Assert;

public class ElasticsearchTemplateLite
extends ElasticsearchTemplate {
    public ElasticsearchTemplateLite(Client client, ElasticsearchConverter elasticsearchConverter) {
        super(client, elasticsearchConverter);
    }

    private String getPersistentEntityId(Object entity) {
        Assert.notNull((Object)entity, (String)"the document can not be null");
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        Object identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier();
        Assert.notNull((Object)identifier, (String)"the document id can not be null");
        return identifier.toString();
    }

    public String put(Object entity) {
        IndexQuery indexQuery = new IndexQueryBuilder().withId(this.getPersistentEntityId(entity)).withObject(entity).build();
        return this.index(indexQuery);
    }

    public String put(Object entity, String parentId) {
        Assert.hasText((String)parentId, (String)"the parentId is null.");
        IndexQuery indexQuery = new IndexQueryBuilder().withId(this.getPersistentEntityId(entity)).withParentId(parentId).withObject(entity).build();
        return this.index(indexQuery);
    }

    public <T> String deleteById(Object entity) {
        return this.delete(entity.getClass(), this.getPersistentEntityId(entity));
    }

    public <T> String deleteById(Class<T> clazz, Object id) {
        Assert.notNull((Object)id, (String)"the document id can not be null");
        return this.delete(clazz, id.toString());
    }

    public <T> T findById(Object id, Class<T> clazz) {
        GetQuery getQuery = new GetQuery();
        getQuery.setId(id.toString());
        return (T)this.queryForObject(getQuery, clazz);
    }

    public <T> T findById(Object entity) {
        GetQuery getQuery = new GetQuery();
        getQuery.setId(this.getPersistentEntityId(entity));
        return (T)this.queryForObject(getQuery, entity.getClass());
    }

    public <T> Page<T> findForPage(PageParamBuilder<T> pageParamBuilder) {
        String highlightColor;
        SortBuilder<?> sortBuilder;
        QueryBuilder filterBuilder;
        Assert.notNull(pageParamBuilder, (String)"the pageable builder is null.");
        Class<T> clazz = pageParamBuilder.getClazz();
        Assert.notNull(clazz, (String)"the pageable builder clazz property is null.");
        QueryBuilder queryBuilder = pageParamBuilder.getQueryBuilder();
        NativeSearchQueryBuilder searchQueryBuilder = null;
        String keyword = pageParamBuilder.getKeyword();
        searchQueryBuilder = ValidateKit.isNotEmpty((Object)keyword) ? new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)keyword)) : (ValidateKit.isNotNull((Object)queryBuilder) ? new NativeSearchQueryBuilder().withQuery(queryBuilder) : new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()));
        Pageable pageable = pageParamBuilder.getPageable();
        if (ValidateKit.isNotNull((Object)pageable)) {
            searchQueryBuilder.withPageable(pageable);
        }
        if (ValidateKit.isNotNull((Object)(filterBuilder = pageParamBuilder.getFilterBuilder()))) {
            searchQueryBuilder.withFilter(filterBuilder);
        }
        if (ValidateKit.isNotNull(sortBuilder = pageParamBuilder.getSortBuilder())) {
            searchQueryBuilder.withSort(sortBuilder);
        }
        if (ValidateKit.isNull((Object)(highlightColor = pageParamBuilder.getHighlightColor()))) {
            return this.queryForPage((SearchQuery)searchQueryBuilder.build(), clazz);
        }
        HighlightBuilder.Field[] highlightFields = pageParamBuilder.getHighlightFields();
        if (ValidateKit.isNull((Object)highlightFields)) {
            String preTags = "<font color='" + highlightColor + "'>";
            String postTags = "</font>";
            HighlightBuilder.Field highlightField = (HighlightBuilder.Field)((HighlightBuilder.Field)new HighlightBuilder.Field("*").preTags(new String[]{preTags})).postTags(new String[]{postTags});
            searchQueryBuilder.withHighlightFields(new HighlightBuilder.Field[]{highlightField});
        } else {
            searchQueryBuilder.withHighlightFields(highlightFields);
        }
        return this.queryForPage((SearchQuery)searchQueryBuilder.build(), clazz, new HighlightResultMapper());
    }

    public static class HighlightResultMapper
    implements SearchResultMapper {
        public <T> AggregatedPage<T> mapResults(SearchResponse searchResponse, Class<T> clazz, Pageable pageable) {
            TotalHits totalHits = searchResponse.getHits().getTotalHits();
            ArrayList<Object> list = new ArrayList<Object>();
            SearchHits hits = searchResponse.getHits();
            if (hits.getHits().length > 0) {
                for (SearchHit searchHit : hits) {
                    Field[] fields;
                    Map highlightFields = searchHit.getHighlightFields();
                    String sourceAsString = searchHit.getSourceAsString();
                    Object item = JacksonKit.toObj((String)sourceAsString, clazz);
                    for (Field field : fields = clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        if (!highlightFields.containsKey(field.getName())) continue;
                        try {
                            field.set(item, ((HighlightField)highlightFields.get(field.getName())).fragments()[0].toString());
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    list.add(item);
                }
            }
            long total = 0L;
            if (ValidateKit.isNotNull((Object)totalHits)) {
                total = totalHits.value;
            }
            return new AggregatedPageImpl(list, pageable, total);
        }
    }
}

