/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.openingo.java.lang.ThreadLocalX;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.reflect.ClassKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.data.elasticsearch.builder.DocBuilder;
import org.openingo.spring.extension.data.elasticsearch.builder.index.MappingsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.util.Assert;

public class RestHighLevelClientX {
    private static final Logger log = LoggerFactory.getLogger(RestHighLevelClientX.class);
    private static final String ASYNC = "async";
    private static final String SYNC = "sync";
    private static final ThreadLocalX<String> PROCESSING_WAY_HOLDER = new ThreadLocalX();
    private RestHighLevelClient restHighLevelClient;

    public RestHighLevelClientX(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public RestHighLevelClient client() {
        return this.restHighLevelClient;
    }

    public RestHighLevelClientX async() {
        PROCESSING_WAY_HOLDER.set((Object)ASYNC);
        return this;
    }

    public RestHighLevelClientX sync() {
        PROCESSING_WAY_HOLDER.set((Object)SYNC);
        return this;
    }

    private String getProcessingWay() {
        String way = (String)PROCESSING_WAY_HOLDER.getRemove();
        if (ValidateKit.isNull((Object)way)) {
            way = SYNC;
        }
        return way;
    }

    public boolean createIndex(String index, Settings settings, MappingsProperties mappingsProperties) throws IOException {
        CreateIndexResponse createIndexResponse;
        boolean exists = this.restHighLevelClient.indices().exists(new GetIndexRequest(new String[]{index}), RequestOptions.DEFAULT);
        if (exists) {
            log.info("index \"{}\" is exist!", (Object)index);
            return true;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        if (ValidateKit.isNotNull((Object)settings)) {
            createIndexRequest.settings(settings);
        }
        if (ValidateKit.isNotNull((Object)mappingsProperties)) {
            createIndexRequest.mapping(mappingsProperties.toJson(), XContentType.JSON);
        }
        return ValidateKit.isNotNull((Object)(createIndexResponse = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT))) && createIndexResponse.isAcknowledged();
    }

    public boolean saveOrUpdate(String index, String docId, Map<String, Object> map) throws IOException {
        return this.saveOrUpdate(index, docId, map, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean saveOrUpdate(String index, String docId, Map<String, Object> map, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        Assert.notNull(map, (String)"the map must not be null!");
        String json = JacksonKit.toJson(map);
        return this.saveOrUpdate(index, docId, json, XContentType.JSON, refreshPolicy);
    }

    public boolean saveOrUpdate(String index, String docId, String json) throws IOException {
        return this.saveOrUpdate(index, docId, json, XContentType.JSON, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean saveOrUpdate(String index, String docId, String json, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.saveOrUpdate(index, docId, json, XContentType.JSON, refreshPolicy);
    }

    public boolean saveOrUpdate(String index, String docId, String source, XContentType xContentType) throws IOException {
        return this.saveOrUpdate(index, docId, source, xContentType, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean saveOrUpdate(String index, String docId, String source, XContentType xContentType, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index).id(docId).source(source, xContentType);
        return this.saveOrUpdate(indexRequest, refreshPolicy);
    }

    public boolean saveOrUpdate(IndexRequest indexRequest) throws IOException {
        return this.saveOrUpdate(indexRequest, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean saveOrUpdate(IndexRequest indexRequest, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        Assert.notNull((Object)indexRequest, (String)"the indexRequest must not be null!");
        return this.saveOrUpdateDocs(Collections.singletonList(indexRequest), refreshPolicy);
    }

    public boolean saveOrUpdateDocs(List<IndexRequest> indexRequests) throws IOException {
        Assert.notNull(indexRequests, (String)"the indexRequests must not be null!");
        return this.saveOrUpdateDocs(indexRequests, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean saveOrUpdateDocs(List<IndexRequest> indexRequests, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.saveOrUpdateDocs(indexRequests, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean saveOrUpdateDocs(List<IndexRequest> indexRequests, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        return this.bulkRequest(indexRequests, refreshPolicy, options);
    }

    public boolean saveOrUpdateByDocBuilders(List<DocBuilder> builders) throws IOException {
        return this.saveOrUpdateByDocBuilders(builders, WriteRequest.RefreshPolicy.NONE, RequestOptions.DEFAULT);
    }

    public boolean saveOrUpdateByDocBuilders(List<DocBuilder> builders, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.saveOrUpdateByDocBuilders(builders, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean saveOrUpdateByDocBuilders(List<DocBuilder> builders, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        Assert.notNull(builders, (String)"the builders must not be null!");
        BulkRequest bulkRequest = new BulkRequest();
        for (DocBuilder docBuilder : builders) {
            IndexRequest indexRequest = new IndexRequest(docBuilder.getDocIndex()).id(docBuilder.getDocId()).source(docBuilder.getDocSource(), XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (ValidateKit.isNotNull((Object)refreshPolicy)) {
            bulkRequest.setRefreshPolicy(refreshPolicy);
        }
        return this.bulkRequest(bulkRequest, options);
    }

    public boolean partialUpdate(String index, String docId, Map<String, Object> map) throws IOException {
        return this.partialUpdate(index, docId, map, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdate(String index, String docId, Map<String, Object> map, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        Assert.notNull(map, (String)"the map must not be null!");
        String json = JacksonKit.toJson(map);
        return this.partialUpdate(index, docId, json, XContentType.JSON, refreshPolicy);
    }

    public boolean partialUpdate(String index, String docId, String json) throws IOException {
        return this.partialUpdate(index, docId, json, XContentType.JSON, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdate(String index, String docId, String json, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.partialUpdate(index, docId, json, XContentType.JSON, refreshPolicy);
    }

    public boolean partialUpdate(String index, String docId, String source, XContentType xContentType) throws IOException {
        return this.partialUpdate(index, docId, source, xContentType, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdate(String index, String docId, String source, XContentType xContentType, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(index, docId).doc(source, xContentType);
        return this.partialUpdate(updateRequest, refreshPolicy);
    }

    public boolean partialUpdate(UpdateRequest updateRequest) throws IOException {
        return this.partialUpdate(updateRequest, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdate(UpdateRequest updateRequest, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        Assert.notNull((Object)updateRequest, (String)"the updateRequest must not be null!");
        return this.partialUpdate(Collections.singletonList(updateRequest), refreshPolicy);
    }

    public boolean partialUpdate(List<UpdateRequest> updateRequests) throws IOException {
        Assert.notNull(updateRequests, (String)"the updateRequests must not be null!");
        return this.partialUpdate(updateRequests, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdate(List<UpdateRequest> updateRequests, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.partialUpdate(updateRequests, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean partialUpdate(List<UpdateRequest> updateRequests, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        return this.bulkRequest(updateRequests, refreshPolicy, options);
    }

    public boolean partialUpdateDocs(List<UpdateRequest> updateRequests) throws IOException {
        Assert.notNull(updateRequests, (String)"the updateRequests must not be null!");
        return this.partialUpdateDocs(updateRequests, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean partialUpdateDocs(List<UpdateRequest> updateRequests, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.partialUpdateDocs(updateRequests, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean partialUpdateDocs(List<UpdateRequest> updateRequests, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        return this.bulkRequest(updateRequests, refreshPolicy, options);
    }

    public boolean partialUpdateByDocBuilders(List<DocBuilder> builders) throws IOException {
        return this.partialUpdateByDocBuilders(builders, WriteRequest.RefreshPolicy.NONE, RequestOptions.DEFAULT);
    }

    public boolean partialUpdateByDocBuilders(List<DocBuilder> builders, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.partialUpdateByDocBuilders(builders, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean partialUpdateByDocBuilders(List<DocBuilder> builders, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        Assert.notNull(builders, (String)"the builders must not be null!");
        BulkRequest bulkRequest = new BulkRequest();
        for (DocBuilder docBuilder : builders) {
            UpdateRequest updateRequest = new UpdateRequest(docBuilder.getDocIndex(), docBuilder.getDocId()).doc(docBuilder.getDocSource(), XContentType.JSON);
            bulkRequest.add(updateRequest);
        }
        if (ValidateKit.isNotNull((Object)refreshPolicy)) {
            bulkRequest.setRefreshPolicy(refreshPolicy);
        }
        return this.bulkRequest(bulkRequest, options);
    }

    public boolean deleteByDocId(String index, String docId) throws IOException {
        return this.deleteByDocIds(index, Collections.singletonList(docId), WriteRequest.RefreshPolicy.NONE);
    }

    public boolean deleteByDocId(String index, String docId, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.deleteByDocIds(index, Collections.singletonList(docId), refreshPolicy);
    }

    public boolean deleteByDocIds(String index, List<String> docIds) throws IOException {
        return this.deleteByDocIds(index, docIds, WriteRequest.RefreshPolicy.NONE);
    }

    public boolean deleteByDocIds(String index, List<String> docIds, WriteRequest.RefreshPolicy refreshPolicy) throws IOException {
        return this.deleteByDocIds(index, docIds, refreshPolicy, RequestOptions.DEFAULT);
    }

    public boolean deleteByDocIds(String index, List<String> docIds, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        docIds.forEach(docId -> bulkRequest.add(new DeleteRequest(index, docId)));
        bulkRequest.setRefreshPolicy(refreshPolicy);
        return this.bulkRequest(bulkRequest, options);
    }

    private boolean bulkRequest(List<? extends DocWriteRequest<?>> requests, WriteRequest.RefreshPolicy refreshPolicy, RequestOptions options) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        if (ValidateKit.isNotNull((Object)refreshPolicy)) {
            bulkRequest.setRefreshPolicy(refreshPolicy);
        }
        requests.forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        return this.bulkRequest(bulkRequest, options);
    }

    private boolean bulkRequest(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        String way = this.getProcessingWay();
        final boolean[] ret = new boolean[]{true};
        switch (way) {
            case "sync": {
                BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                ret[0] = ValidateKit.isNotNull((Object)bulkResponse) && RestStatus.OK.equals((Object)bulkResponse.status());
                break;
            }
            case "async": {
                this.restHighLevelClient.bulkAsync(bulkRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse bulkItemResponses) {
                        ret[0] = ValidateKit.isNotNull((Object)bulkItemResponses) && RestStatus.OK.equals((Object)bulkItemResponses.status());
                    }

                    public void onFailure(Exception e) {
                        log.error("==the async bulk request error \"{}\"==", (Object)e.getLocalizedMessage());
                        ret[0] = false;
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + way);
            }
        }
        return ret[0];
    }

    private MultiGetItemResponse[] findAsResponse(String index, List<String> docIds) throws IOException {
        Assert.notNull(docIds, (String)"the docIds must not be null!");
        String way = this.getProcessingWay();
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        docIds.forEach(docId -> multiGetRequest.add(index, docId));
        final MultiGetResponse[] multiGetResponses = new MultiGetResponse[1];
        switch (way) {
            case "sync": {
                multiGetResponses[0] = this.restHighLevelClient.mget(multiGetRequest, RequestOptions.DEFAULT);
                break;
            }
            case "async": {
                this.restHighLevelClient.mgetAsync(multiGetRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<MultiGetResponse>(){

                    public void onResponse(MultiGetResponse multiGetItemResponses) {
                        multiGetResponses[0] = multiGetItemResponses;
                    }

                    public void onFailure(Exception e) {
                        log.error("==the async mget failure => \"{}\"==", (Object)e.getLocalizedMessage());
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + way);
            }
        }
        if (ValidateKit.isNull((Object)multiGetResponses[0])) {
            return null;
        }
        return multiGetResponses[0].getResponses();
    }

    public Map<String, Object> findAsMapById(String index, String docId) throws IOException {
        MultiGetItemResponse[] multiGetItemResponses = this.findAsResponse(index, Collections.singletonList(docId));
        if (ValidateKit.isNull((Object)multiGetItemResponses)) {
            return new HashMap<String, Object>();
        }
        return multiGetItemResponses[0].getResponse().getSourceAsMap();
    }

    public <T> T findById(Class<T> clazz, String index, String docId) throws IOException {
        MultiGetItemResponse[] multiGetItemResponses = this.findAsResponse(index, Collections.singletonList(docId));
        if (ValidateKit.isNull((Object)multiGetItemResponses)) {
            return (T)ClassKit.newInstance(clazz);
        }
        String sourceAsString = multiGetItemResponses[0].getResponse().getSourceAsString();
        return (T)JacksonKit.toObj((String)sourceAsString, clazz);
    }

    public List<Map<String, Object>> findAsMapByIds(String index, List<String> docIds) throws IOException {
        MultiGetItemResponse[] multiGetItemResponses = this.findAsResponse(index, docIds);
        if (ValidateKit.isNull((Object)multiGetItemResponses)) {
            return ListKit.emptyList();
        }
        List docMaps = ListKit.emptyArrayList((int)multiGetItemResponses.length);
        for (MultiGetItemResponse multiGetItemResponse : multiGetItemResponses) {
            Map sourceAsMap = multiGetItemResponse.getResponse().getSourceAsMap();
            docMaps.add(sourceAsMap);
        }
        return docMaps;
    }

    public <T> List<T> findByIds(Class<T> clazz, String index, List<String> docIds) throws IOException {
        List<Map<String, Object>> docMaps = this.findAsMapByIds(index, docIds);
        if (ValidateKit.isNull(docMaps)) {
            return ListKit.emptyList();
        }
        return JacksonKit.toList((String)JacksonKit.toJson(docMaps), clazz);
    }

    public <T> AggregatedPageImpl<T> searchForPage(Class<T> clazz, String index, SearchSourceBuilder searchSourceBuilder, int pageNumber, int pageSize) throws IOException {
        Assert.notNull((Object)searchSourceBuilder, (String)"the searchSourceBuilder cannot be null");
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        if (pageSize < 0) {
            pageSize = 10;
        }
        if (searchSourceBuilder.from() == -1) {
            searchSourceBuilder.from(pageNumber * pageSize);
        }
        if (searchSourceBuilder.size() == -1) {
            searchSourceBuilder.size(pageSize);
        }
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.timeout(TimeValue.timeValueSeconds((long)2L));
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(searchSourceBuilder);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        SearchResponse response = this.doSearch(searchRequest);
        AggregatedPageImpl aggregatedPage = null;
        if (ValidateKit.isNotNull((Object)response)) {
            aggregatedPage = this.pagination(clazz, ValidateKit.isNotNull((Object)searchSourceBuilder.highlighter()), response, pageable);
        }
        if (ValidateKit.isNull(aggregatedPage)) {
            aggregatedPage = new AggregatedPageImpl(ListKit.emptyList(), (Pageable)pageable, 0L);
        }
        return aggregatedPage;
    }

    public <T> List<T> randomRecommend(Class<T> clazz, String index, int recommendSize) throws IOException {
        return this.randomRecommend(clazz, index, recommendSize, null, null, null, null);
    }

    public <T> List<T> randomRecommend(Class<T> clazz, String index, int recommendSize, QueryBuilder queryBuilder, HighlightBuilder highlightBuilder) throws IOException {
        return this.randomRecommend(clazz, index, recommendSize, queryBuilder, highlightBuilder, null, null);
    }

    public <T> List<T> randomRecommend(Class<T> clazz, String index, int recommendSize, QueryBuilder queryBuilder, HighlightBuilder highlightBuilder, String docIdFieldName, List<String> excludeDocIds) throws IOException {
        if (recommendSize <= 0) {
            recommendSize = 8;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(recommendSize);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (ValidateKit.isNotNull((Object)queryBuilder)) {
            if (queryBuilder instanceof BoolQueryBuilder) {
                boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
            } else {
                boolQueryBuilder.must(queryBuilder);
            }
        }
        if (ValidateKit.isAllNotNull((Object[])new Object[]{docIdFieldName, excludeDocIds})) {
            boolQueryBuilder.mustNot((QueryBuilder)new TermsQueryBuilder(docIdFieldName, excludeDocIds));
        }
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.functionScoreQuery((ScoreFunctionBuilder)new RandomScoreFunctionBuilder()));
        searchSourceBuilder.sort((SortBuilder)SortBuilders.scoreSort());
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.highlighter(highlightBuilder);
        List searchRet = ListKit.emptyList();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(searchSourceBuilder);
        SearchResponse response = this.doSearch(searchRequest);
        if (ValidateKit.isNotNull((Object)response)) {
            SearchHit[] searchHits = response.getHits().getHits();
            searchRet = ListKit.emptyArrayList((int)searchHits.length);
            this.highlightPageData(clazz, ValidateKit.isNotNull((Object)highlightBuilder), searchRet, searchHits);
        }
        return searchRet;
    }

    private SearchResponse doSearch(SearchRequest searchRequest) throws IOException {
        String way = this.getProcessingWay();
        final SearchResponse[] responses = new SearchResponse[1];
        switch (way) {
            case "sync": {
                responses[0] = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
                break;
            }
            case "async": {
                this.restHighLevelClient.searchAsync(searchRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        responses[0] = searchResponse;
                    }

                    public void onFailure(Exception e) {
                        log.error("==the async search failure => \"{}\"==", (Object)e.getMessage());
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + way);
            }
        }
        return responses[0];
    }

    private <T> AggregatedPageImpl<T> pagination(Class<T> clazz, boolean highlight, SearchResponse response, PageRequest pageable) throws IOException {
        SearchHits searchHits;
        SearchHit[] hits;
        List searchRet;
        AggregatedPageImpl aggregatedPage = null;
        if (ValidateKit.isNotNull((Object)response) && RestStatus.OK.equals((Object)response.status()) && this.highlightPageData(clazz, highlight, searchRet = ListKit.emptyArrayList((int)(hits = (searchHits = response.getHits()).getHits()).length), hits)) {
            long total = 0L;
            TotalHits totalHits = searchHits.getTotalHits();
            if (ValidateKit.isNotNull((Object)totalHits)) {
                total = totalHits.value;
            }
            aggregatedPage = new AggregatedPageImpl(searchRet, (Pageable)pageable, total);
        }
        log.info("the pagination = \"{}\",  response => \"{}\"", aggregatedPage, (Object)response);
        return aggregatedPage;
    }

    private <T> boolean highlightPageData(Class<T> clazz, boolean highlight, List<T> searchRet, SearchHit[] hits) throws JsonProcessingException {
        if (ValidateKit.isEmpty((Object)hits)) {
            return false;
        }
        List tmpRet = ListKit.emptyArrayList((int)hits.length);
        if (!highlight) {
            for (SearchHit hit : hits) {
                Map sourceAsMap = hit.getSourceAsMap();
                tmpRet.add(sourceAsMap);
            }
        } else {
            for (SearchHit hit : hits) {
                Map sourceAsMap = hit.getSourceAsMap();
                Map highlightFields = hit.getHighlightFields();
                highlightFields.keySet().forEach(key -> {
                    Object val = sourceAsMap.get(key);
                    if (!(val instanceof String)) {
                        return;
                    }
                    StringBuilder newData = new StringBuilder();
                    HighlightField highlightField = (HighlightField)highlightFields.get(key);
                    if (ValidateKit.isNotNull((Object)highlightField)) {
                        Text[] fragments;
                        for (Text fragment : fragments = highlightField.getFragments()) {
                            newData.append(fragment.toString());
                        }
                    } else {
                        newData.append(val.toString());
                    }
                    sourceAsMap.put(key, newData.toString());
                });
                tmpRet.add(sourceAsMap);
            }
        }
        if (ValidateKit.isNotEmpty((Object)tmpRet)) {
            searchRet.addAll(JacksonKit.toList((String)JacksonKit.toJson((Object)tmpRet), clazz));
        }
        return true;
    }
}

