/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.elasticsearch.builder;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.extension.data.elasticsearch.kit.KeywordKit;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public final class PageParamBuilder<T> {
    private Class<T> clazz;
    private String keyword;
    private String highlightColor;
    private Pageable pageable;
    private HighlightBuilder.Field[] highlightFields;
    private QueryBuilder queryBuilder;
    private QueryBuilder filterBuilder;
    private SortBuilder<?> sortBuilder;

    private PageParamBuilder() {
    }

    public static <T> PageParamBuilder<T> builder() {
        return new PageParamBuilder<T>();
    }

    public PageParamBuilder<T> clazz(Class<T> clazz) {
        this.clazz = clazz;
        return this;
    }

    public PageParamBuilder<T> keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public PageParamBuilder<T> keywords(String ... keywords) {
        this.keyword = KeywordKit.toKeyword(keywords);
        return this;
    }

    public PageParamBuilder<T> highlightColor(String highlightColor) {
        this.highlightColor = highlightColor;
        return this;
    }

    public PageParamBuilder<T> pageable(Integer pageNum, Integer pageSize) {
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        this.pageable = PageRequest.of((int)(pageNum - 1), (int)pageSize);
        return this;
    }

    public PageParamBuilder<T> highlightFields(HighlightBuilder.Field ... highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public PageParamBuilder<T> query(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public PageParamBuilder<T> matchAllQuery() {
        this.queryBuilder = QueryBuilders.matchAllQuery();
        return this;
    }

    public PageParamBuilder<T> filter(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public PageParamBuilder<T> sort(String fieldSort, SortOrder order, String unmappedType) {
        Assert.hasText((String)fieldSort, (String)"the sort field is not exist");
        Assert.notNull((Object)order, (String)"the sort order is null");
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)fieldSort).order(order);
        if (ValidateKit.isNotEmpty((Object)unmappedType)) {
            sortBuilder.unmappedType(unmappedType);
        }
        this.sortBuilder = sortBuilder;
        return this;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getHighlightColor() {
        return this.highlightColor;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public HighlightBuilder.Field[] getHighlightFields() {
        return this.highlightFields;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public QueryBuilder getFilterBuilder() {
        return this.filterBuilder;
    }

    public SortBuilder<?> getSortBuilder() {
        return this.sortBuilder;
    }
}

