/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.extension.data.redis.config;

import java.net.UnknownHostException;
import org.openingo.spring.extension.data.redis.RedisStringKeyTemplateX;
import org.openingo.spring.extension.data.redis.RedisTemplateX;
import org.openingo.spring.extension.data.redis.naming.DefaultKeyNamingPolicy;
import org.openingo.spring.extension.data.redis.naming.IKeyNamingPolicy;
import org.openingo.spring.extension.data.redis.serializer.FstRedisSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@ConditionalOnProperty(prefix="openingo.redis", name={"enable"}, havingValue="true")
@ConditionalOnClass(value={RedisTemplate.class, RedisOperations.class})
public class RedisConfig {
    @Bean
    @ConditionalOnMissingBean(name={"redisTemplateX"})
    public RedisTemplateX<Object, Object> redisTemplateX(RedisTemplate<Object, Object> redisTemplate) {
        return new RedisTemplateX<Object, Object>(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisStringKeyTemplateX"})
    public RedisStringKeyTemplateX<Object> redisStringKeyTemplateX(RedisTemplate<String, Object> redisStringKeyTemplate) {
        return new RedisStringKeyTemplateX<Object>(redisStringKeyTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisStringKeyTemplate"})
    public RedisTemplate<String, Object> redisStringKeyTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(RedisSerializer.string());
        redisTemplate.setValueSerializer(this.valueRedisSerializer());
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(name={"valueRedisSerializer"})
    public RedisSerializer<Object> valueRedisSerializer() {
        return new FstRedisSerializer<Object>();
    }

    @Bean
    @ConditionalOnMissingBean
    public IKeyNamingPolicy keyNamingPolicy() {
        return new DefaultKeyNamingPolicy();
    }
}

