/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.gedid.engine;

import java.util.Objects;
import org.openingo.spring.gedid.engine.IDidEngine;
import org.openingo.spring.safety.Safety;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DidEngine<T> {
    private static final Logger log = LoggerFactory.getLogger(DidEngine.class);
    private final String name;
    private final Safety safety = new Safety();
    private final IDidEngine<T> engine;

    public DidEngine(String name, IDidEngine<T> engine) {
        this(name, null, engine);
    }

    public DidEngine(String name, T startId, IDidEngine<T> engine) {
        this.name = name;
        this.engine = engine;
        this.follow(name, startId);
    }

    private void follow(String name, T startId) {
        if (Objects.isNull(startId)) {
            this.safety.safetyRun(() -> this.engine.follow(name));
        } else {
            this.safety.safetyRun(() -> this.engine.follow(name, startId));
        }
        log.info("`{}` engine followed with name `{}` and startId `{}`", new Object[]{this.engine.getClass().getSimpleName(), name, startId});
    }

    public T current() {
        return (T)this.safety.safetyCall(() -> this.engine.current(this.name));
    }

    public T next() {
        return (T)this.safety.safetyCall(() -> this.engine.next(this.name));
    }

    public String getName() {
        return this.name;
    }
}

