/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.websocket;

import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.websocket.InstantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/instant-ws/{connId}")
public class WebsocketServerEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WebsocketServerEndpoint.class);
    private static final Long EXPIRE_TIME = 86400000L;
    Integer connId;
    Session session;
    private long connTime;
    private long lastActiveTime;

    private void fixLastActiveTime() {
        this.lastActiveTime = SystemClockKit.now();
    }

    @OnOpen
    private void onOpen(Session session, @PathParam(value="connId") Integer dataId) {
        this.connId = dataId;
        this.session = session;
        this.connTime = SystemClockKit.now();
        this.lastActiveTime = SystemClockKit.now();
        session.setMaxIdleTimeout(EXPIRE_TIME.longValue());
        InstantManager.manager.addConnection(dataId, this);
    }

    @OnMessage
    private void onMessage(String message, Session session) {
        this.fixLastActiveTime();
    }

    @OnError
    private void onError(Session session, Throwable e) {
        log.error("WebsocketServerEndpoint has error, connId = {}, leisure time {} ms.", (Object)this.connId, (Object)(SystemClockKit.now() - this.lastActiveTime));
        log.error("", e);
    }

    @OnClose
    private void onClose() throws IOException {
        log.info("WebsocketServerEndpoint onClose, connId = {}, live time {} ms.", (Object)this.connId, (Object)(SystemClockKit.now() - this.connTime));
        if (ValidateKit.isNotNull((Object)this.connId)) {
            InstantManager.manager.removeConnection(this.connId, this);
        }
    }

    RemoteEndpoint.Basic getBasicRemote() {
        this.fixLastActiveTime();
        return this.session.getBasicRemote();
    }

    RemoteEndpoint.Async getAsyncRemote() {
        this.fixLastActiveTime();
        return this.session.getAsyncRemote();
    }
}

