/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.spring.extension.gedid.config;

import org.apache.curator.framework.CuratorFramework;
import org.openingo.spring.gedid.engine.redis.RedisIdEngine;
import org.openingo.spring.gedid.engine.uuid.UuidEngine;
import org.openingo.spring.gedid.engine.zookeeper.ZookeeperIdEngine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

/**
 * GeDidConfig
 *
 * @author Qicz
 * @since 2021/6/23 10:24
 */
@Configuration
public class GeDidConfig {

	@Bean
	@ConditionalOnMissingBean(name = "redisIdEngine")
	public RedisIdEngine redisIdEngine(StringRedisTemplate stringRedisTemplate) {
		return new RedisIdEngine(stringRedisTemplate);
	}

	@Bean
	@ConditionalOnMissingBean(name = "zookeeperIdEngine")
	public ZookeeperIdEngine zookeeperIdEngine(CuratorFramework curator) {
		return new ZookeeperIdEngine(curator);
	}

	@Bean
	@ConditionalOnMissingBean(name = "uuidEngine")
	public UuidEngine uuidEngine() {
		return new UuidEngine();
	}
}
