/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.spring.gedid.engine;

import lombok.extern.slf4j.Slf4j;
import org.openingo.spring.safety.Safety;

import java.util.Objects;

/**
 * DidEngine
 *
 * @author Qicz
 * @since 2021/6/23 10:33
 */
@Slf4j
public class DidEngine<T> {

	private final String name;

	private final Safety safety = new Safety();

	private final IDidEngine<T> engine;

	public DidEngine(String name, IDidEngine<T> engine) {
		this(name, null, engine);
	}

	public DidEngine(String name, T startId, IDidEngine<T> engine) {
		this.name = name;
		this.engine = engine;
		this.follow(name, startId);
	}

	/**
	 * Follow The business with name.
	 * @param name biz name
	 * @param startId the first id
	 */
	private void follow(String name, T startId) {
		if (Objects.isNull(startId)) {
			this.safety.safetyRun(() -> this.engine.follow(name));
		} else {
			this.safety.safetyRun(() -> this.engine.follow(name, startId));
		}
		log.info("`{}` engine followed with name `{}` and startId `{}`", this.engine.getClass().getSimpleName(), name, startId);
	}

	/**
	 * @return Next id.
	 */
	public T next() {
		return this.safety.safetyCall(() -> this.engine.next(this.name));
	}

	public String getName() {
		return name;
	}
}
