/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.spring.gedid.engine;

/**
 * IDidEngine
 *
 * @author Qicz
 * @since 2021/6/25 10:48
 */
public interface IDidEngine<T> {

	/**
	 * Follow The business with name.
	 * @param name biz name
	 */
	void follow(String name);

	/**
	 * Follow The business with name.
	 * @param name biz name
	 * @param startId the first id
	 */
	void follow(String name, T startId);

	/**
	 * @return Next id.
	 */
	T next(String name);

	/**
	 * throw onw unsupportedOperationException
	 * @param operation unsupported operation
	 */
	default void unsupportedOperation(String operation) {
		throw new UnsupportedOperationException(String.format("`%s` : The `%s` Operation is not supported!", this.getClass().getSimpleName(), operation));
	}
}
