/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.spring.tx;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

/**
 * ManualTransactionManager
 *
 * @author Qicz
 * @since 2021/6/28 16:35
 */
@Slf4j
public class ManualTransactionManager {

	private final PlatformTransactionManager transactionManager;

	private final TransactionDefinition transactionDefinition;

	public ManualTransactionManager(PlatformTransactionManager transactionManager,
									TransactionDefinition transactionDefinition) {
		this.transactionManager = transactionManager;
		this.transactionDefinition = transactionDefinition;
	}

	public void txRun(TxRunnable runnable) {
		TransactionStatus transactionStatus = transactionManager.getTransaction(transactionDefinition);
		try {
			runnable.run();
			transactionManager.commit(transactionStatus);
		} catch (Exception e) {
			log.error(e.getLocalizedMessage());
			transactionManager.rollback(transactionStatus);
		}
	}

	public <T> T txCall(TxCallable<T> callable) {
		TransactionStatus transactionStatus = transactionManager.getTransaction(transactionDefinition);
		T ret = null;
		try {
			ret = callable.call();
			transactionManager.commit(transactionStatus);
		} catch (Exception e) {
			log.error(e.getLocalizedMessage());
			transactionManager.rollback(transactionStatus);
		}
		return ret;
	}
}
