/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Constants;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Tables;

public class ConstantPool
implements Iterable<ConstCell> {
    private ArrayList<ConstCell> pool = new ArrayList(20);
    private final ConstValue ConstValue0 = new ConstValue_String("");
    private final ConstCell nullConst = new ConstCell(null);
    private final ConstCell constant_0 = new ConstCell(new ConstValue_Zero());
    Hashtable<ConstValue, ConstCell> cpoolHashByValue = new Hashtable(40);
    public Environment env;
    private static boolean debugCP = false;
    private CPVisitor<Void> fixCPVstr = new CPVisitor<Void>(){

        @Override
        public Void visitUTF8(ConstValue_String p) {
            return null;
        }

        @Override
        public Void visitInteger(ConstValue_Integer p) {
            return null;
        }

        @Override
        public Void visitFloat(ConstValue_Integer p) {
            return null;
        }

        @Override
        public Void visitDouble(ConstValue_Long p) {
            return null;
        }

        @Override
        public Void visitLong(ConstValue_Long p) {
            return null;
        }

        @Override
        public Void visitMethodtype(ConstValue_Cell p) {
            this.handleClassRef(p);
            return null;
        }

        @Override
        public Void visitString(ConstValue_Cell p) {
            this.handleClassRef(p);
            return null;
        }

        @Override
        public Void visitClass(ConstValue_Cell p) {
            this.handleClassRef(p);
            return null;
        }

        @Override
        public Void visitMethod(ConstValue_Pair p) {
            this.handleMemberRef(p);
            return null;
        }

        @Override
        public Void visitField(ConstValue_Pair p) {
            this.handleMemberRef(p);
            return null;
        }

        @Override
        public Void visitInterfacemethod(ConstValue_Pair p) {
            this.handleMemberRef(p);
            return null;
        }

        @Override
        public Void visitNameandtype(ConstValue_Pair p) {
            this.handleMemberRef(p);
            return null;
        }

        @Override
        public Void visitMethodhandle(ConstValue_Pair p) {
            this.handleMemberRef(p);
            return null;
        }

        @Override
        public Void visitDynamic(ConstValue_CondyPair p) {
            return null;
        }

        @Override
        public Void visitInvokedynamic(ConstValue_IndyPair p) {
            return null;
        }

        @Override
        public Void visitModule(ConstValue_Cell p) {
            this.handleClassRef(p);
            return null;
        }

        @Override
        public Void visitPackage(ConstValue_Cell p) {
            this.handleClassRef(p);
            return null;
        }

        public void handleClassRef(ConstValue_Cell cv) {
            ConstCell clref = cv.cell;
            if (clref.ref == null) {
                ConstCell refval = ConstantPool.this.cpool_get(clref.arg);
                if (refval != null) {
                    ConstantPool.this.checkAndFixCPRef(clref.arg, refval);
                    clref.ref = refval.ref;
                } else {
                    clref.ref = null;
                }
            }
        }

        public void handleMemberRef(ConstValue_Pair cv) {
            ConstCell refval;
            ConstCell clref = cv.left;
            ConstCell typref = cv.right;
            if (clref.ref == null) {
                refval = ConstantPool.this.cpool_get(clref.arg);
                if (refval != null) {
                    ConstantPool.this.checkAndFixCPRef(clref.arg, refval);
                    clref.ref = refval.ref;
                } else {
                    clref.ref = null;
                }
            }
            if (typref.ref == null) {
                refval = ConstantPool.this.cpool_get(typref.arg);
                if (refval != null) {
                    ConstantPool.this.checkAndFixCPRef(typref.arg, refval);
                    typref.ref = refval.ref;
                } else {
                    typref.ref = null;
                }
            }
        }
    };

    public ConstantPool(Environment env) {
        this.env = env;
        this.pool.add(this.constant_0);
    }

    public void debugStr(String s) {
        if (debugCP) {
            this.env.traceln(s);
        }
    }

    @Override
    public Iterator<ConstCell> iterator() {
        return this.pool.iterator();
    }

    public void fixRefsInPool() {
        this.env.traceln("Fixing CP for explicit Constant Entries.");
        int i = 0;
        for (ConstCell item : this.pool) {
            ++i;
            if (item == null) continue;
            this.checkAndFixCPRef(i, item);
        }
    }

    protected void CheckGlobals() {
        this.env.traceln("Checking Globals");
        for (int cpx = 1; cpx < this.pool.size(); ++cpx) {
            ConstValue cval;
            ConstCell cell = this.pool.get(cpx);
            if (cell == this.nullConst) {
                cell = new ConstCell(cpx, this.ConstValue0);
                this.pool.set(cpx, cell);
            }
            if ((cval = cell.ref) != null && cval.hasValue()) continue;
            String name = Integer.toString(cpx);
            this.env.error("const.undecl", (Object)name);
        }
    }

    private void checkAndFixCPRef(int i, ConstCell item) {
        ConstValue cv = item.ref;
        if (cv != null) {
            this.fixCPVstr.visit(cv);
        }
    }

    public void printPool() {
        int i = 0;
        for (ConstCell item : this.pool) {
            this.env.traceln("^^^^^^^^^^^^^  const #" + i + ": " + item);
            ++i;
        }
    }

    private ConstCell cpool_get(int cpx) {
        if (cpx >= this.pool.size()) {
            return null;
        }
        return this.pool.get(cpx);
    }

    private void cpool_set(int cpx, ConstCell cell, int sz) {
        this.debugStr("cpool_set1: " + cpx + " " + cell);
        this.debugStr("param_size: " + sz);
        this.debugStr("pool_size: " + this.pool.size());
        cell.arg = cpx;
        if (cpx + sz >= this.pool.size()) {
            this.debugStr("calling ensureCapacity( " + (cpx + sz + 1) + ")");
            int low = this.pool.size();
            int high = cpx + sz;
            for (int i = 0; i < high - low; ++i) {
                this.pool.add(this.nullConst);
            }
        }
        this.pool.set(cpx, cell);
        if (sz == 2) {
            this.pool.set(cpx + 1, new ConstCell(cpx + 1, this.ConstValue0));
        }
        this.debugStr(" cpool_set2: " + cpx + " " + cell);
    }

    protected ConstCell uncheckedGetCell(int cpx) {
        return this.pool.get(cpx);
    }

    public ConstCell getCell(int cpx) {
        ConstCell cell = this.cpool_get(cpx);
        if (cell != null) {
            return cell;
        }
        cell = new ConstCell(cpx, null);
        return cell;
    }

    public void setCell(int cpx, ConstCell cell) {
        ConstValue value = cell.ref;
        if (value == null) {
            throw new Parser.CompilerError(this.env.errorStr("comperr.constcell.nullvalset"));
        }
        int sz = value.size();
        if (cpx == 0) {
            this.env.error("warn.const0.redecl");
        } else {
            if (this.cpool_get(cpx) != null || sz == 2 && this.cpool_get(cpx + 1) != null) {
                String name = "#" + cpx;
                this.env.error("const.redecl", (Object)name);
                return;
            }
            if (cell.isSet() && cell.arg != cpx) {
                this.env.traceln("setCell: new ConstCell");
                cell = new ConstCell(value);
            }
        }
        this.cpool_set(cpx, cell, sz);
    }

    protected void NumberizePool() {
        this.env.traceln("NumberizePool");
        for (ReferenceRank rank : ReferenceRank.values()) {
            for (ConstCell cell : this.cpoolHashByValue.values().stream().filter(v -> !v.isSet() && rank.equals((Object)v.rank)).collect(Collectors.toList())) {
                int cpx;
                ConstValue value = cell.ref;
                if (value == null) {
                    throw new Parser.CompilerError(this.env.errorStr("comperr.constcell.nullvalhash"));
                }
                int sz = value.size();
                for (cpx = 1; cpx < this.pool.size() && (this.pool.get(cpx) != this.nullConst || sz != 1 && this.pool.get(cpx + 1) != this.nullConst); ++cpx) {
                }
                this.cpool_set(cpx, cell, sz);
            }
        }
        ConstCell firstCell = this.cpool_get(0);
        firstCell.arg = 0;
    }

    public ConstCell FindCell(ConstValue ref) {
        if (ref == null) {
            throw new Parser.CompilerError(this.env.errorStr("comperr.constcell.nullval"));
        }
        ConstCell pconst = null;
        try {
            pconst = this.cpoolHashByValue.get(ref);
        }
        catch (Parser.CompilerError e) {
            throw new Parser.CompilerError(this.env.errorStr("comperr.constcell.nullvalhash"));
        }
        if (pconst != null) {
            ConstValue value = pconst.ref;
            if (!value.equals(ref)) {
                throw new Parser.CompilerError(this.env.errorStr("comperr.val.noteq"));
            }
            return pconst;
        }
        pconst = new ConstCell(ref);
        this.cpoolHashByValue.put(ref, pconst);
        return pconst;
    }

    public ConstCell FindCell(Tables.ConstType tag, String value) {
        return this.FindCell(new ConstValue_String(value));
    }

    public ConstCell FindCell(Tables.ConstType tag, Integer value) {
        return this.FindCell(new ConstValue_Integer(tag, value));
    }

    public ConstCell FindCell(Tables.ConstType tag, Long value) {
        return this.FindCell(new ConstValue_Long(tag, value));
    }

    public ConstCell FindCell(Tables.ConstType tag, ConstCell value) {
        return this.FindCell(new ConstValue_Cell(tag, value));
    }

    public ConstCell FindCell(Tables.ConstType tag, ConstCell left, ConstCell right) {
        return this.FindCell(new ConstValue_Pair(tag, left, right));
    }

    public ConstCell FindCellAsciz(String str) {
        return this.FindCell(Tables.ConstType.CONSTANT_UTF8, str);
    }

    public ConstCell FindCellClassByName(String name) {
        return this.FindCell(Tables.ConstType.CONSTANT_CLASS, this.FindCellAsciz(name));
    }

    public ConstCell FindCellModuleByName(String name) {
        return this.FindCell(Tables.ConstType.CONSTANT_MODULE, this.FindCellAsciz(name));
    }

    public ConstCell FindCellPackageByName(String name) {
        return this.FindCell(Tables.ConstType.CONSTANT_PACKAGE, this.FindCellAsciz(name));
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        ConstValue value;
        int length = this.pool.size();
        out.writeShort(length);
        this.env.traceln("wr.pool:size=" + length);
        for (int i = 1; i < length; i += value.size()) {
            ConstCell cell = this.pool.get(i);
            value = cell.ref;
            if (cell.arg != i) {
                throw new Parser.CompilerError(this.env.errorStr("comperr.constcell.invarg", Integer.toString(i), cell.arg));
            }
            value.write(out);
        }
    }

    public static class CPVisitor<R>
    implements Constants {
        public final R visit(ConstValue val) {
            R retVal = null;
            Tables.ConstType tag = val.tag;
            switch (tag) {
                case CONSTANT_UTF8: {
                    retVal = this.visitUTF8((ConstValue_String)val);
                    break;
                }
                case CONSTANT_INTEGER: {
                    retVal = this.visitInteger((ConstValue_Integer)val);
                    break;
                }
                case CONSTANT_FLOAT: {
                    retVal = this.visitFloat((ConstValue_Integer)val);
                    break;
                }
                case CONSTANT_DOUBLE: {
                    retVal = this.visitDouble((ConstValue_Long)val);
                    break;
                }
                case CONSTANT_LONG: {
                    retVal = this.visitLong((ConstValue_Long)val);
                    break;
                }
                case CONSTANT_METHODTYPE: {
                    retVal = this.visitMethodtype((ConstValue_Cell)val);
                    break;
                }
                case CONSTANT_STRING: {
                    retVal = this.visitString((ConstValue_Cell)val);
                    break;
                }
                case CONSTANT_CLASS: {
                    retVal = this.visitClass((ConstValue_Cell)val);
                    break;
                }
                case CONSTANT_METHOD: {
                    retVal = this.visitMethod((ConstValue_Pair)val);
                    break;
                }
                case CONSTANT_FIELD: {
                    retVal = this.visitField((ConstValue_Pair)val);
                    break;
                }
                case CONSTANT_INTERFACEMETHOD: {
                    retVal = this.visitInterfacemethod((ConstValue_Pair)val);
                    break;
                }
                case CONSTANT_NAMEANDTYPE: {
                    retVal = this.visitNameandtype((ConstValue_Pair)val);
                    break;
                }
                case CONSTANT_METHODHANDLE: {
                    retVal = this.visitMethodhandle((ConstValue_Pair)val);
                    break;
                }
                case CONSTANT_DYNAMIC: {
                    retVal = this.visitDynamic((ConstValue_CondyPair)val);
                    break;
                }
                case CONSTANT_INVOKEDYNAMIC: {
                    retVal = this.visitInvokedynamic((ConstValue_IndyPair)val);
                    break;
                }
                case CONSTANT_MODULE: {
                    retVal = this.visitModule((ConstValue_Cell)val);
                    break;
                }
                case CONSTANT_PACKAGE: {
                    retVal = this.visitPackage((ConstValue_Cell)val);
                    break;
                }
                default: {
                    this.visitDefault(tag);
                }
            }
            return retVal;
        }

        public R visitUTF8(ConstValue_String p) {
            return null;
        }

        public R visitInteger(ConstValue_Integer p) {
            return null;
        }

        public R visitFloat(ConstValue_Integer p) {
            return null;
        }

        public R visitDouble(ConstValue_Long p) {
            return null;
        }

        public R visitLong(ConstValue_Long p) {
            return null;
        }

        public R visitMethodtype(ConstValue_Cell p) {
            return null;
        }

        public R visitString(ConstValue_Cell p) {
            return null;
        }

        public R visitClass(ConstValue_Cell p) {
            return null;
        }

        public R visitMethod(ConstValue_Pair p) {
            return null;
        }

        public R visitField(ConstValue_Pair p) {
            return null;
        }

        public R visitInterfacemethod(ConstValue_Pair p) {
            return null;
        }

        public R visitNameandtype(ConstValue_Pair p) {
            return null;
        }

        public R visitMethodhandle(ConstValue_Pair p) {
            return null;
        }

        public R visitDynamic(ConstValue_CondyPair p) {
            return null;
        }

        public R visitInvokedynamic(ConstValue_IndyPair p) {
            return null;
        }

        public R visitModule(ConstValue_Cell p) {
            return null;
        }

        public R visitPackage(ConstValue_Cell p) {
            return null;
        }

        public void visitDefault(Tables.ConstType tag) {
        }
    }

    public static class CPTagVisitor<R>
    implements Constants {
        public final R visit(Tables.ConstType tag) {
            R retVal = null;
            switch (tag) {
                case CONSTANT_UTF8: {
                    retVal = this.visitUTF8(tag);
                    break;
                }
                case CONSTANT_INTEGER: {
                    retVal = this.visitInteger(tag);
                    break;
                }
                case CONSTANT_FLOAT: {
                    retVal = this.visitFloat(tag);
                    break;
                }
                case CONSTANT_DOUBLE: {
                    retVal = this.visitDouble(tag);
                    break;
                }
                case CONSTANT_LONG: {
                    retVal = this.visitLong(tag);
                    break;
                }
                case CONSTANT_METHODTYPE: {
                    retVal = this.visitMethodtype(tag);
                    break;
                }
                case CONSTANT_STRING: {
                    retVal = this.visitString(tag);
                    break;
                }
                case CONSTANT_CLASS: {
                    retVal = this.visitClass(tag);
                    break;
                }
                case CONSTANT_METHOD: {
                    retVal = this.visitMethod(tag);
                    break;
                }
                case CONSTANT_FIELD: {
                    retVal = this.visitField(tag);
                    break;
                }
                case CONSTANT_INTERFACEMETHOD: {
                    retVal = this.visitInterfacemethod(tag);
                    break;
                }
                case CONSTANT_NAMEANDTYPE: {
                    retVal = this.visitNameandtype(tag);
                    break;
                }
                case CONSTANT_METHODHANDLE: {
                    retVal = this.visitMethodhandle(tag);
                    break;
                }
                case CONSTANT_DYNAMIC: {
                    retVal = this.visitDynamic(tag);
                    break;
                }
                case CONSTANT_INVOKEDYNAMIC: {
                    retVal = this.visitInvokedynamic(tag);
                    break;
                }
                default: {
                    this.visitDefault(tag);
                }
            }
            return retVal;
        }

        public R visitUTF8(Tables.ConstType tag) {
            return null;
        }

        public R visitInteger(Tables.ConstType tag) {
            return null;
        }

        public R visitFloat(Tables.ConstType tag) {
            return null;
        }

        public R visitDouble(Tables.ConstType tag) {
            return null;
        }

        public R visitLong(Tables.ConstType tag) {
            return null;
        }

        public R visitMethodtype(Tables.ConstType tag) {
            return null;
        }

        public R visitString(Tables.ConstType tag) {
            return null;
        }

        public R visitClass(Tables.ConstType tag) {
            return null;
        }

        public R visitMethod(Tables.ConstType tag) {
            return null;
        }

        public R visitField(Tables.ConstType tag) {
            return null;
        }

        public R visitInterfacemethod(Tables.ConstType tag) {
            return null;
        }

        public R visitNameandtype(Tables.ConstType tag) {
            return null;
        }

        public R visitMethodhandle(Tables.ConstType tag) {
            return null;
        }

        public R visitDynamic(Tables.ConstType tag) {
            return null;
        }

        public R visitInvokedynamic(Tables.ConstType tag) {
            return null;
        }

        public R visitModule(Tables.ConstType tag) {
            return null;
        }

        public R visitPackage(Tables.ConstType tag) {
            return null;
        }

        public void visitDefault(Tables.ConstType tag) {
        }
    }

    public static class ConstCell
    extends Argument
    implements Data {
        ConstValue ref;
        ReferenceRank rank = ReferenceRank.NO;

        ConstCell(int arg, ConstValue ref) {
            this.arg = arg;
            this.ref = ref;
        }

        ConstCell(ConstValue ref) {
            this(-1, ref);
        }

        ConstCell(int arg) {
            this(arg, null);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.arg);
        }

        public void setRank(ReferenceRank rank) {
            if (this.rank != ReferenceRank.LDC) {
                this.rank = rank;
            }
        }

        @Override
        public int hashCode() {
            if (this.arg == -1) {
                if (this.ref != null) {
                    return this.ref.hashCode();
                }
                throw new Parser.CompilerError("Can't generate Hash Code, Null ConstCell Reference.");
            }
            return this.arg;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            ConstCell cc = (ConstCell)obj;
            if (cc.ref == null) {
                return this.ref == null && cc.rank == this.rank;
            }
            return cc.ref.equals(this.ref) && cc.rank == this.rank;
        }

        public boolean isUnset() {
            return this.arg == -1 && this.ref == null;
        }

        public String toString() {
            return "#" + this.arg + "=" + this.ref;
        }
    }

    public static class ConstValue_IndyPair
    extends ConstValue_IndyOrCondyPair {
        public ConstValue_IndyPair(BootstrapMethodData bsmdata, ConstCell napeCell) {
            super(Tables.ConstType.CONSTANT_INVOKEDYNAMIC, bsmdata, napeCell);
        }
    }

    public static class ConstValue_CondyPair
    extends ConstValue_IndyOrCondyPair {
        public ConstValue_CondyPair(BootstrapMethodData bsmdata, ConstCell napeCell) {
            super(Tables.ConstType.CONSTANT_DYNAMIC, bsmdata, napeCell);
        }
    }

    public static class ConstValue_IndyOrCondyPair
    extends ConstValue {
        BootstrapMethodData bsmData;
        ConstCell napeCell;

        protected ConstValue_IndyOrCondyPair(Tables.ConstType tag, BootstrapMethodData bsmdata, ConstCell napeCell) {
            super(tag);
            assert (tag == Tables.ConstType.CONSTANT_DYNAMIC && ConstValue_CondyPair.class.isAssignableFrom(this.getClass()) || tag == Tables.ConstType.CONSTANT_INVOKEDYNAMIC && ConstValue_IndyPair.class.isAssignableFrom(this.getClass()));
            this.bsmData = bsmdata;
            this.napeCell = napeCell;
            this.isSet = bsmdata != null && napeCell != null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().isInstance(obj)) {
                return false;
            }
            ConstValue_IndyOrCondyPair iobj = (ConstValue_IndyOrCondyPair)obj;
            return iobj.bsmData == this.bsmData && iobj.napeCell == this.napeCell;
        }

        @Override
        public String toString() {
            return super.toString() + "{" + this.bsmData + "," + this.napeCell + "}";
        }

        @Override
        protected int _hashCode() {
            if (this.bsmData.isPlaceholder()) {
                return this.napeCell.hashCode();
            }
            return this.bsmData.hashCode() * this.napeCell.hashCode();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeShort(this.bsmData.arg);
            out.writeShort(this.napeCell.arg);
        }
    }

    public static class ConstValue_Pair
    extends ConstValue {
        ConstCell left;
        ConstCell right;

        public ConstValue_Pair(Tables.ConstType tag, ConstCell left, ConstCell right) {
            super(tag);
            this.left = left;
            this.right = right;
            this.isSet = left != null && right != null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstValue_Pair)) {
                return false;
            }
            ConstValue_Pair dobj = (ConstValue_Pair)obj;
            if (this.tag != dobj.tag) {
                return false;
            }
            if (dobj.left != null && !dobj.left.equals(this.left)) {
                return false;
            }
            return dobj.right == null || dobj.right.equals(this.right);
        }

        @Override
        public String toString() {
            return super.toString() + "{" + this.left + "," + this.right + "}";
        }

        @Override
        protected int _hashCode() {
            return this.left.hashCode() * this.right.hashCode();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            if (this.tag == Tables.ConstType.CONSTANT_METHODHANDLE) {
                out.writeByte(this.left.arg);
            } else {
                out.writeShort(this.left.arg);
            }
            out.writeShort(this.right.arg);
        }
    }

    public static class ConstValue_Cell
    extends ConstValue {
        ConstCell cell;

        public ConstValue_Cell(Tables.ConstType tag, ConstCell cell) {
            super(tag);
            this.cell = cell;
            this.isSet = cell != null;
        }

        @Override
        protected String _toString() {
            return this.cell.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstValue_Cell)) {
                return false;
            }
            ConstValue_Cell dobj = (ConstValue_Cell)obj;
            if (this.tag != dobj.tag) {
                return false;
            }
            return this.cell.equals(dobj.cell);
        }

        @Override
        protected int _hashCode() {
            return this.cell.hashCode();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            this.cell.write(out);
        }
    }

    public static class ConstValue_Long
    extends ConstValue {
        Long value;

        public ConstValue_Long(Tables.ConstType tag, Long value) {
            super(tag);
            this.value = value;
            this.isSet = value != null;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        protected String _toString() {
            return this.value.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstValue_Long)) {
                return false;
            }
            ConstValue_Long dobj = (ConstValue_Long)obj;
            if (this.tag != dobj.tag) {
                return false;
            }
            return this.value.equals(dobj.value);
        }

        @Override
        protected int _hashCode() {
            return this.value.hashCode();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeLong(this.value);
        }
    }

    public static class ConstValue_Integer
    extends ConstValue {
        Integer value;

        public ConstValue_Integer(Tables.ConstType tag, Integer value) {
            super(tag);
            this.value = value;
            this.isSet = value != null;
        }

        @Override
        protected String _toString() {
            return this.value.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstValue_Integer)) {
                return false;
            }
            ConstValue_Integer dobj = (ConstValue_Integer)obj;
            if (this.tag != dobj.tag) {
                return false;
            }
            return this.value.equals(dobj.value);
        }

        @Override
        protected int _hashCode() {
            return this.value.hashCode();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeInt(this.value);
        }
    }

    public static class ConstValue_String
    extends ConstValue {
        String value;

        public ConstValue_String(String value) {
            super(Tables.ConstType.CONSTANT_UTF8);
            this.value = value;
            this.isSet = value != null;
        }

        @Override
        protected String _toString() {
            return this.value;
        }

        @Override
        protected int _hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstValue_String)) {
                return false;
            }
            ConstValue_String dobj = (ConstValue_String)obj;
            if (this.tag != dobj.tag) {
                return false;
            }
            return this.value.equals(dobj.value);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeUTF(this.value);
        }
    }

    public static class ConstValue_Zero
    extends ConstValue {
        public ConstValue_Zero() {
            super(Tables.ConstType.CONSTANT_ZERO);
            this.isSet = false;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            throw new Parser.CompilerError("Trying to write Constant 0.");
        }
    }

    public static class ConstValue {
        protected Tables.ConstType tag;
        protected boolean isSet = false;
        private boolean visited = false;

        public ConstValue(Tables.ConstType tag) {
            this.tag = tag;
        }

        public int size() {
            return 1;
        }

        public boolean hasValue() {
            return this.isSet;
        }

        public int hashCode() {
            if (this.visited) {
                throw new Parser.CompilerError("CV hash:" + this);
            }
            this.visited = true;
            int res = this._hashCode() + this.tag.value() * 1023;
            this.visited = false;
            return res;
        }

        protected int _hashCode() {
            return 37;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public String toString() {
            String tagstr = this.tag.printval();
            String retval = "";
            if (tagstr == null) {
                return "BOGUS_TAG:" + (Object)((Object)this.tag);
            }
            String valueStr = this._toString();
            retval = valueStr != null ? "<" + tagstr + " " + valueStr + ">" : "<" + tagstr + ">";
            return retval;
        }

        protected String _toString() {
            return "";
        }

        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.tag.value());
        }
    }

    public static enum ReferenceRank {
        LDC(0),
        ANY(1),
        NO(2);

        final int rank;

        private ReferenceRank(int rank) {
            this.rank = rank;
        }
    }
}

