/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.CodeAttr;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Constants;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Tables;

class MethodData
extends MemberData {
    protected Environment env;
    protected ConstantPool.ConstCell nameCell;
    protected ConstantPool.ConstCell sigCell;
    protected CodeAttr code;
    protected DataVectorAttr<ConstantPool.ConstCell> exceptions = null;
    protected DataVectorAttr<ParamNameData> paramNames = null;
    protected DataPArrayAttr<AnnotationData> pannotAttrVis = null;
    protected DataPArrayAttr<AnnotationData> pannotAttrInv = null;
    protected DefaultAnnotationAttr defaultAnnot = null;

    public MethodData(ClassData cls, int acc, ConstantPool.ConstCell name, ConstantPool.ConstCell sig, ArrayList<ConstantPool.ConstCell> exc_table) {
        super(cls, acc);
        this.env = cls.env;
        this.nameCell = name;
        this.sigCell = sig;
        if (exc_table != null && !exc_table.isEmpty()) {
            this.exceptions = new DataVectorAttr<ConstantPool.ConstCell>(cls, Tables.AttrTag.ATT_Exceptions.parsekey(), exc_table);
        }
        if (Modifiers.hasPseudoMod(acc)) {
            this.createPseudoMod();
        }
    }

    public void addMethodParameter(int totalParams, int paramNum, ConstantPool.ConstCell name, int access) {
        this.env.traceln("addMethodParameter Param[" + paramNum + "] (name: " + name.toString() + ", Flags (" + access + ").");
        if (this.paramNames == null) {
            this.paramNames = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_MethodParameters.parsekey(), true);
            for (int i = 0; i < totalParams; ++i) {
                this.paramNames.add(new ParamNameData(0, null));
            }
        }
        this.paramNames.put(paramNum, new ParamNameData(access, name));
    }

    public CodeAttr startCode(int pos, int paramcnt, Argument max_stack, Argument max_locals) {
        this.code = new CodeAttr(this, pos, paramcnt, max_stack, max_locals);
        return this.code;
    }

    public void addDefaultAnnotation(DefaultAnnotationAttr data) {
        this.defaultAnnot = data;
    }

    public void addParamAnnotation(int totalParams, int paramNum, AnnotationData data) {
        if (!data.invisible) {
            if (this.pannotAttrVis == null) {
                this.pannotAttrVis = new DataPArrayAttr(this.cls, Tables.AttrTag.ATT_RuntimeVisibleParameterAnnotations.parsekey(), totalParams);
            }
            this.pannotAttrVis.put(paramNum, data);
        } else {
            if (this.pannotAttrInv == null) {
                this.pannotAttrInv = new DataPArrayAttr(this.cls, Tables.AttrTag.ATT_RuntimeInvisibleParameterAnnotations.parsekey(), totalParams);
            }
            this.pannotAttrInv.put(paramNum, data);
        }
    }

    @Override
    protected DataVector getAttrVector() {
        DataVector dv = this.getDataVector(this.exceptions, this.syntheticAttr, this.deprecatedAttr, this.paramNames, this.code, this.defaultAnnot);
        if (this.pannotAttrVis != null) {
            dv.add(this.pannotAttrVis);
        }
        if (this.pannotAttrInv != null) {
            dv.add(this.pannotAttrInv);
        }
        return dv;
    }

    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        out.writeShort(this.access);
        out.writeShort(this.nameCell.arg);
        out.writeShort(this.sigCell.arg);
        this.getAttrVector().write(out);
    }

    public static class DataPArrayAttr<T extends Data>
    extends AttrData
    implements Constants {
        TreeMap<Integer, ArrayList<T>> elements;
        int paramsTotal;

        public DataPArrayAttr(ClassData cls, String name, int paramsTotal, TreeMap<Integer, ArrayList<T>> elements) {
            super(cls, name);
            this.paramsTotal = paramsTotal;
            this.elements = elements;
        }

        public DataPArrayAttr(ClassData cls, String name, int paramsTotal) {
            this(cls, name, paramsTotal, new TreeMap<Integer, ArrayList<T>>());
        }

        public void put(int paramNum, T element) {
            ArrayList<Object> v = this.get(paramNum);
            if (v == null) {
                v = new ArrayList();
                this.elements.put(paramNum, v);
            }
            v.add(element);
        }

        public ArrayList<T> get(int paramNum) {
            return this.elements.get(paramNum);
        }

        @Override
        public int attrLength() {
            int length = 1;
            for (int i = 0; i < this.paramsTotal; ++i) {
                ArrayList<T> attrarray = this.get(i);
                if (attrarray != null) {
                    for (Data item : attrarray) {
                        length += item.getLength();
                    }
                }
                length += 2;
            }
            return length;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeByte(this.paramsTotal);
            for (int i = 0; i < this.paramsTotal; ++i) {
                ArrayList<T> attrarray = this.get(i);
                if (attrarray != null) {
                    out.writeShort(attrarray.size());
                    for (Data item : attrarray) {
                        item.write(out);
                    }
                    continue;
                }
                out.writeShort(0);
            }
        }
    }

    class ParamNameData
    implements Data {
        int access;
        ConstantPool.ConstCell name;

        public ParamNameData(int access, ConstantPool.ConstCell name) {
            this.access = access;
            this.name = name;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            int nm = 0;
            int ac = 0;
            if (this.name != null) {
                nm = this.name.arg;
                ac = this.access;
            }
            out.writeShort(nm);
            out.writeShort(ac);
        }
    }
}

