/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openjdk.asmtools.common.Module;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.Tables;

class ModuleAttr
extends AttrData {
    private Module.Builder builder;
    private final ClassData clsData;
    private final Function<String, ConstantPool.ConstCell> findCellAsciz;
    private final Function<String, ConstantPool.ConstCell> findCellClassByName;
    private final Function<String, ConstantPool.ConstCell> findCellModuleByName;
    private final Function<String, ConstantPool.ConstCell> findCellPackageByName;
    BiConsumer<String, Integer> requires = (mn, f) -> this.builder.require((String)mn, (int)f);
    BiConsumer<String, Set<String>> exports = (pn, ms) -> this.builder.exports(new Module.Exported((String)pn), (Set<String>)ms);
    BiConsumer<String, Set<String>> opens = (pn, ms) -> this.builder.opens(new Module.Opened((String)pn), (Set<String>)ms);
    BiConsumer<String, Set<String>> provides = (tn, ts) -> this.builder.provides(new Module.Provided((String)tn), (Set<String>)ts);
    Consumer<Set<String>> uses = ts -> this.builder.uses((Set<String>)ts);

    ModuleAttr(ClassData cdata) {
        super(cdata, Tables.AttrTag.ATT_Module.parsekey());
        this.builder = new Module.Builder();
        this.clsData = cdata;
        this.findCellAsciz = name -> this.clsData.pool.FindCellAsciz((String)name);
        this.findCellClassByName = name -> this.clsData.pool.FindCellClassByName((String)name);
        this.findCellModuleByName = name -> this.clsData.pool.FindCellModuleByName((String)name);
        this.findCellPackageByName = name -> this.clsData.pool.FindCellPackageByName((String)name);
    }

    void openModule() {
        this.builder.setModuleFlags(Module.Modifier.ACC_OPEN);
    }

    void setModuleName(String value) {
        this.builder.setModuleName(value);
    }

    ModuleAttr build() {
        Module module = this.builder.build();
        Content.instance.header = new HeaderStruct(module.header, this.findCellModuleByName, this.findCellAsciz);
        Content.instance.requiresStruct = new SetStruct<Module.Dependence>(module.requires, this.findCellModuleByName, this.findCellAsciz);
        Content.instance.exportsMapStruct = new MapStruct<Module.Exported>(module.exports, this.findCellPackageByName, this.findCellModuleByName);
        Content.instance.opensMapStruct = new MapStruct<Module.Opened>(module.opens, this.findCellPackageByName, this.findCellModuleByName);
        Content.instance.usesStruct = new SetStruct<Module.Uses>(module.uses, this.findCellClassByName, null);
        Content.instance.providesMapStruct = new MapStruct<Module.Provided>(module.provides, this.findCellClassByName, this.findCellClassByName);
        return this;
    }

    @Override
    public int attrLength() {
        return Content.instance.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        Content.instance.write(out);
    }

    public class Triplet<F, S, T>
    extends Pair<F, S> {
        private final T third;

        Triplet(F first, S second, T third) {
            super(first, second);
            this.third = third;
        }
    }

    private class Pair<F, S> {
        final F first;
        final S second;

        Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }

    private class SetStruct<T extends Module.TargetType>
    implements Data {
        final List<ConstantPool.ConstCell> usesList = new ArrayList<ConstantPool.ConstCell>();
        final List<Triplet<ConstantPool.ConstCell, Integer, ConstantPool.ConstCell>> requiresList = new ArrayList<Triplet<ConstantPool.ConstCell, Integer, ConstantPool.ConstCell>>();

        SetStruct(Set<T> source, Function<String, ConstantPool.ConstCell> nameFinder, Function<String, ConstantPool.ConstCell> versionFinder) {
            Objects.requireNonNull(source);
            source.forEach(e -> {
                if (e.isFlagged()) {
                    this.requiresList.add(new Triplet<ConstantPool.ConstCell, Integer, Object>((ConstantPool.ConstCell)nameFinder.apply(e.getTypeName()), ((Module.FlaggedTargetType)e).getFlags(), (((Module.VersionedFlaggedTargetType)e).getVersion() == null ? null : (ConstantPool.ConstCell)versionFinder.apply(((Module.VersionedFlaggedTargetType)e).getVersion()))));
                } else {
                    this.usesList.add((ConstantPool.ConstCell)nameFinder.apply(e.getTypeName()));
                }
            });
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            if (this.usesList.isEmpty()) {
                out.writeShort(this.requiresList.size());
                for (Triplet<ConstantPool.ConstCell, Integer, ConstantPool.ConstCell> r : this.requiresList) {
                    out.writeShort(((ConstantPool.ConstCell)r.first).arg);
                    out.writeShort((Integer)r.second);
                    out.writeShort(((Triplet)r).third == null ? 0 : ((ConstantPool.ConstCell)((Triplet)r).third).arg);
                }
            } else {
                out.writeShort(this.usesList.size());
                for (ConstantPool.ConstCell u : this.usesList) {
                    out.writeShort(u.arg);
                }
            }
        }

        @Override
        public int getLength() {
            return this.usesList.isEmpty() ? 2 + 6 * this.requiresList.size() : 2 + 2 * this.usesList.size();
        }
    }

    private class HeaderStruct
    implements Data {
        final ConstantPool.ConstCell index;
        final int flags;
        final ConstantPool.ConstCell versionIndex;

        HeaderStruct(Module.Header source, Function<String, ConstantPool.ConstCell> nameFinder, Function<String, ConstantPool.ConstCell> versionFinder) {
            this.index = nameFinder.apply(source.getModuleName());
            this.versionIndex = source.getModuleVersion() == null ? null : versionFinder.apply(source.getModuleVersion());
            this.flags = source.getModuleFlags();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.index.arg);
            out.writeShort(this.flags);
            out.writeShort(this.versionIndex == null ? 0 : this.versionIndex.arg);
        }

        @Override
        public int getLength() {
            return 6;
        }
    }

    private class MapStruct<T extends Module.TargetType>
    implements Data {
        final List<Triplet<ConstantPool.ConstCell, Integer, List<ConstantPool.ConstCell>>> exportsOpensList = new ArrayList<Triplet<ConstantPool.ConstCell, Integer, List<ConstantPool.ConstCell>>>();
        final List<Pair<ConstantPool.ConstCell, List<ConstantPool.ConstCell>>> providesList = new ArrayList<Pair<ConstantPool.ConstCell, List<ConstantPool.ConstCell>>>();

        MapStruct(Map<T, Set<String>> source, Function<String, ConstantPool.ConstCell> nameFinder, Function<String, ConstantPool.ConstCell> targetFinder) {
            Objects.requireNonNull(source);
            source.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
                ArrayList to = new ArrayList();
                ((Set)e.getValue()).forEach(mn -> to.add((ConstantPool.ConstCell)targetFinder.apply((String)mn)));
                if (((Module.TargetType)e.getKey()).isFlagged()) {
                    this.exportsOpensList.add(new Triplet((ConstantPool.ConstCell)nameFinder.apply(((Module.TargetType)e.getKey()).getTypeName()), ((Module.FlaggedTargetType)e.getKey()).getFlags(), to));
                } else {
                    this.providesList.add(new Pair((ConstantPool.ConstCell)nameFinder.apply(((Module.TargetType)e.getKey()).getTypeName()), to));
                }
            });
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            if (this.providesList.isEmpty()) {
                out.writeShort(this.exportsOpensList.size());
                for (Triplet<ConstantPool.ConstCell, Integer, List<ConstantPool.ConstCell>> triplet : this.exportsOpensList) {
                    out.writeShort(((ConstantPool.ConstCell)triplet.first).arg);
                    out.writeShort((Integer)triplet.second);
                    out.writeShort(((List)((Triplet)triplet).third).size());
                    for (ConstantPool.ConstCell to : (List)((Triplet)triplet).third) {
                        out.writeShort(to.arg);
                    }
                }
            } else {
                out.writeShort(this.providesList.size());
                for (Pair<ConstantPool.ConstCell, List<ConstantPool.ConstCell>> pair : this.providesList) {
                    out.writeShort(((ConstantPool.ConstCell)pair.first).arg);
                    out.writeShort(((List)pair.second).size());
                    for (ConstantPool.ConstCell to : (List)pair.second) {
                        out.writeShort(to.arg);
                    }
                }
            }
        }

        @Override
        public int getLength() {
            if (this.providesList.isEmpty()) {
                return 2 + 6 * this.exportsOpensList.size() + this.exportsOpensList.stream().mapToInt(p -> ((List)((Triplet)p).third).size()).filter(s -> s > 0).sum() * 2;
            }
            return 2 + 4 * this.providesList.size() + this.providesList.stream().mapToInt(p -> ((List)p.second).size()).filter(s -> s > 0).sum() * 2;
        }
    }

    private static enum Content implements Data
    {
        instance{

            @Override
            public int getLength() {
                return this.header.getLength() + this.requiresStruct.getLength() + this.exportsMapStruct.getLength() + this.opensMapStruct.getLength() + this.usesStruct.getLength() + this.providesMapStruct.getLength();
            }

            @Override
            public void write(CheckedDataOutputStream out) throws IOException {
                this.header.write(out);
                this.requiresStruct.write(out);
                this.exportsMapStruct.write(out);
                this.opensMapStruct.write(out);
                this.usesStruct.write(out);
                this.providesMapStruct.write(out);
            }
        };

        HeaderStruct header;
        SetStruct<Module.Dependence> requiresStruct;
        MapStruct<Module.Exported> exportsMapStruct;
        MapStruct<Module.Opened> opensMapStruct;
        SetStruct<Module.Uses> usesStruct;
        MapStruct<Module.Provided> providesMapStruct;
    }
}

