/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.Tables;

public class StackMapData
implements Data {
    int pc;
    int offset;
    int type;
    String stackFrameType = null;
    boolean isStackMapTable = false;
    DataVector localsMap;
    DataVector stackMap;
    Environment env;

    StackMapData(Environment env) {
        this.env = env;
    }

    void setPC(int pc) {
        this.pc = pc;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    void setOffset(StackMapData prevFrame) {
        this.offset = prevFrame == null ? this.pc : this.pc - prevFrame.pc - 1;
    }

    void setStackFrameType(String stackFrameType) {
        this.stackFrameType = stackFrameType;
        if (stackFrameType != null) {
            this.type = Tables.stackMapFrameTypeValue(stackFrameType);
        }
        if (stackFrameType == null || this.type == -1) {
            this.env.error(this.pc, "invalid.stack.frame.type", (Object)stackFrameType, (Object)("" + this.type));
        }
    }

    void setIsStackMapTable(boolean isStackMapTable) {
        this.isStackMapTable = isStackMapTable;
    }

    void setLocalsMap(DataVector localsMap) {
        this.localsMap = localsMap;
    }

    void setStackMap(DataVector stackMap) {
        this.stackMap = stackMap;
    }

    @Override
    public int getLength() {
        int res = 0;
        Tables.StackMapFrameType frame_type = Tables.StackMapFrameType.FULL_FRAME;
        if (this.isStackMapTable) {
            if (this.stackFrameType != null) {
                frame_type = Tables.stackMapFrameType(this.type);
            }
            ++res;
        }
        switch (frame_type) {
            case SAME_FRAME: {
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                res += this.stackMap.getLength() - 2;
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                res += this.stackMap.getLength();
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: {
                res += 2;
                break;
            }
            case SAME_FRAME_EX: {
                res += 2;
                break;
            }
            case APPEND_FRAME: {
                res += 2 + (this.localsMap == null ? 0 : this.localsMap.getLength() - 2);
                break;
            }
            case FULL_FRAME: {
                res += 2;
                res += this.localsMap == null ? 2 : this.localsMap.getLength();
                res += this.stackMap == null ? 2 : this.stackMap.getLength();
                break;
            }
        }
        return res;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        Tables.StackMapFrameType frame_type = Tables.StackMapFrameType.FULL_FRAME;
        if (this.isStackMapTable && this.stackFrameType != null) {
            frame_type = Tables.stackMapFrameType(this.type);
        }
        switch (frame_type) {
            case SAME_FRAME: {
                if (this.offset >= 64) {
                    this.env.error(this.pc, "invalid.offset.same.frame", (Object)("" + this.offset));
                }
                out.writeByte(this.offset);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                if (this.stackMap == null) {
                    this.env.error(this.pc, "no.stack.map.same.locals");
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.env.error(this.pc, "should.be.only.one.stack.map.element");
                    break;
                }
                if (this.offset >= 64) {
                    this.env.error(this.pc, "invalid.offset.same.locals", (Object)("" + this.offset));
                    break;
                }
                out.writeByte(frame_type.value() + this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                if (this.stackMap == null) {
                    this.env.error(this.pc, "no.stack.map.same.locals");
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.env.error(this.pc, "should.be.only.one.stack.map.element");
                    break;
                }
                out.writeByte(frame_type.value());
                out.writeShort(this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EX: {
                boolean error = false;
                if (this.stackMap != null) {
                    this.env.error(this.pc, "unexpected.stack.maps");
                    error = true;
                }
                if (this.localsMap != null) {
                    this.env.error(this.pc, "unexpected.locals.maps");
                    error = true;
                }
                if (error) break;
                out.writeByte(frame_type.value());
                out.writeShort(this.offset);
                break;
            }
            case APPEND_FRAME: {
                if (this.localsMap == null) {
                    this.env.error(this.pc, "no.locals.map.append");
                    break;
                }
                if (this.localsMap.elements.size() > 3) {
                    this.env.error(this.pc, "more.locals.map.elements");
                    break;
                }
                out.writeByte(frame_type.value() + this.localsMap.elements.size() - 1);
                out.writeShort(this.offset);
                this.localsMap.writeElements(out);
                break;
            }
            case FULL_FRAME: {
                if (this.isStackMapTable) {
                    out.writeByte(frame_type.value());
                    out.writeShort(this.offset);
                } else {
                    out.writeShort(this.pc);
                }
                if (this.localsMap == null) {
                    out.writeShort(0);
                } else {
                    this.localsMap.write(out);
                }
                if (this.stackMap == null) {
                    out.writeShort(0);
                    break;
                }
                this.stackMap.write(out);
                break;
            }
            default: {
                this.env.error(this.pc, "invalid.stack.frame.type", (Object)("" + (Object)((Object)frame_type)));
            }
        }
    }

    public static class StackMapItem2
    implements Data {
        Tables.StackMapType itemType;
        Argument arg;

        StackMapItem2(Tables.StackMapType itemType, Argument arg) {
            this.itemType = itemType;
            this.arg = arg;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemType.value());
            out.writeShort(this.arg.arg);
        }
    }

    public static class StackMapItem1
    implements Data {
        Tables.StackMapType itemType;

        StackMapItem1(Tables.StackMapType itemType) {
            this.itemType = itemType;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemType.value());
        }
    }
}

