/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public abstract class TypeAnnotationTargetInfoData
implements Data {
    protected TypeAnnotationTypes.ETargetType targettype = null;

    public TypeAnnotationTargetInfoData(TypeAnnotationTypes.ETargetType tt) {
        this.targettype = tt;
    }

    public TypeAnnotationTypes.ETargetType getTargetType() {
        return this.targettype;
    }

    public void print(PrintWriter out, String tab) {
        out.print(tab + " {");
        this.targettype.print(out);
        this._print(out, tab);
        out.print(tab + "} ");
    }

    public abstract void _print(PrintWriter var1, String var2);

    @Override
    public abstract void write(CheckedDataOutputStream var1) throws IOException;

    public String toString() {
        return this.toString(0);
    }

    protected abstract void _toString(StringBuilder var1, int var2);

    public String toString(int tabLevel) {
        StringBuilder sb = new StringBuilder(this.tabString(tabLevel));
        sb.append(this.targettype.targetInfo().printValue()).append("_target ");
        this._toString(sb, tabLevel);
        return sb.toString();
    }

    public static class type_argument_target
    extends TypeAnnotationTargetInfoData {
        int offset;
        int typeArgumentIndex;

        public type_argument_target(TypeAnnotationTypes.ETargetType tt, int offset, int index) {
            super(tt);
            this.offset = offset;
            this.typeArgumentIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
            out.writeByte(this.typeArgumentIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.offset);
            out.print(" ");
            out.print(this.typeArgumentIndex);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ offset: %d; type_argument_index: %d; }", this.offset, this.typeArgumentIndex));
        }
    }

    public static class offset_target
    extends TypeAnnotationTargetInfoData {
        int offset;

        public offset_target(TypeAnnotationTypes.ETargetType tt, int offset) {
            super(tt);
            this.offset = offset;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.offset);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ offset: %d; }", this.offset));
        }
    }

    public static class catch_target
    extends TypeAnnotationTargetInfoData {
        int exceptionTableIndex;

        public catch_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.exceptionTableIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.exceptionTableIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.exceptionTableIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ exception_table_index: %d; }", this.exceptionTableIndex));
        }
    }

    public static class localvar_target
    extends TypeAnnotationTargetInfoData {
        ArrayList<LocalVar_Entry> table = null;

        public localvar_target(TypeAnnotationTypes.ETargetType tt, int size) {
            super(tt);
            this.table = new ArrayList(size);
        }

        public void addEntry(int startPC, int length, int cpx) {
            LocalVar_Entry entry = new LocalVar_Entry(startPC, length, cpx);
            this.table.add(entry);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.table.size());
            for (LocalVar_Entry entry : this.table) {
                entry.write(out);
            }
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            String innerTab = tab + " ";
            for (LocalVar_Entry entry : this.table) {
                entry._print(out, innerTab);
            }
            out.print(tab);
        }

        @Override
        public int getLength() {
            return 2 + 6 * this.table.size();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            int i = 0;
            sb.append(this.tabString(tabLevel)).append(String.format("{ %d  {", this.table.size()));
            for (LocalVar_Entry entry : this.table) {
                sb.append(String.format(" [%d]: %s;", i++, entry.toString()));
            }
            sb.append(" } }");
        }

        public class LocalVar_Entry {
            public int startPC;
            public int length;
            public int cpx;

            public LocalVar_Entry(int st, int len, int index) {
                this.startPC = st;
                this.length = len;
                this.cpx = index;
            }

            void write(CheckedDataOutputStream out) throws IOException {
                out.writeShort(this.startPC);
                out.writeShort(this.length);
                out.writeShort(this.cpx);
            }

            public void _print(PrintWriter out, String tab) {
                out.print(tab + "{");
                out.print(this.startPC);
                out.print(" ");
                out.print(this.length);
                out.print(" ");
                out.print(this.cpx);
                out.print("}");
            }

            public String toString() {
                return String.format("start_pc: %d, length: %d, index: %d", this.startPC, this.length, this.cpx);
            }
        }
    }

    public static class throws_target
    extends TypeAnnotationTargetInfoData {
        int throwsTypeIndex;

        public throws_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.throwsTypeIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.throwsTypeIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.throwsTypeIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ throws_type_index: %d; }", this.throwsTypeIndex));
        }
    }

    public static class formal_parameter_target
    extends TypeAnnotationTargetInfoData {
        int formalParamIndex;

        public formal_parameter_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.formalParamIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.formalParamIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.formalParamIndex);
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ formal_parameter_index: %d; }", this.formalParamIndex));
        }
    }

    public static class empty_target
    extends TypeAnnotationTargetInfoData {
        public empty_target(TypeAnnotationTypes.ETargetType tt) {
            super(tt);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append("{ }");
        }
    }

    public static class type_parameter_bound_target
    extends TypeAnnotationTargetInfoData {
        int typeParamIndex;
        int boundIndex;

        public type_parameter_bound_target(TypeAnnotationTypes.ETargetType tt, int pindx, int bindx) {
            super(tt);
            this.typeParamIndex = pindx;
            this.boundIndex = bindx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.typeParamIndex);
            out.writeByte(this.boundIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.typeParamIndex);
            out.print(" ");
            out.print(this.boundIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ type_parameter_index: %d; bound_index: %d; }", this.typeParamIndex, this.boundIndex));
        }
    }

    public static class supertype_target
    extends TypeAnnotationTargetInfoData {
        int superTypeIndex;

        public supertype_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.superTypeIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.superTypeIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.superTypeIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ supertype_index: %d; }", this.superTypeIndex));
        }
    }

    public static class type_parameter_target
    extends TypeAnnotationTargetInfoData {
        int typeParamIndex;

        public type_parameter_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.typeParamIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.typeParamIndex);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.typeParamIndex);
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            sb.append(this.tabString(tabLevel)).append(String.format("{ type_parameter_index: %d; }", this.typeParamIndex));
        }
    }
}

