/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

public class Indenter {
    private int indentLength;

    public Indenter(int indentLength) {
        this.indentLength = indentLength;
    }

    public Indenter() {
        this.indentLength = 2;
    }

    public int indent() {
        return this.indentLength;
    }

    public Indenter setIndent(int indentLength) {
        if (indentLength < 0) {
            throw new IllegalArgumentException("indent length can't be negative");
        }
        this.indentLength = indentLength;
        return this;
    }

    public Indenter increaseIndent(int increase) {
        if (increase < 0) {
            throw new IllegalArgumentException("indent length can't be negative");
        }
        this.setIndent(this.indent() + increase);
        return this;
    }

    public Indenter decreaseIndent(int decrease) {
        if (decrease < 0) {
            throw new IllegalArgumentException("decrease can't be negative");
        }
        this.setIndent(this.indent() - decrease);
        return this;
    }

    public String getIndentString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent(); ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

