/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.TraceUtils;
import org.openjdk.asmtools.jdis.TypeAnnotationData;

public abstract class MemberData
extends Indenter {
    protected int access;
    protected boolean isSynthetic = false;
    protected boolean isDeprecated = false;
    protected SignatureData signature;
    protected ArrayList<AnnotationData> visibleAnnotations;
    protected ArrayList<AnnotationData> invisibleAnnotations;
    protected ArrayList<TypeAnnotationData> visibleTypeAnnotations;
    protected ArrayList<TypeAnnotationData> invisibleTypeAnnotations;
    protected ArrayList<AttrData> attrs;
    protected final Options options = Options.OptionObject();
    protected final boolean pr_cpx = this.options.contains(Options.PR.CPX);
    protected ClassData cls;
    protected PrintWriter out;
    protected String memberType = "";

    public MemberData(ClassData cls) {
        this();
        this.init(cls);
    }

    public MemberData() {
    }

    public void init(ClassData cls) {
        this.out = cls.out;
        this.cls = cls;
    }

    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        return false;
    }

    protected abstract void print() throws IOException;

    protected final int getAnnotationsCount() {
        return (this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size()) + (this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size()) + (this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size()) + (this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size());
    }

    protected final void printAnnotations(String initialTab) {
        if (this.getAnnotationsCount() > 0) {
            if (this.visibleAnnotations != null) {
                for (AnnotationData annotationData : this.visibleAnnotations) {
                    annotationData.print(this.out, initialTab);
                    this.out.println();
                }
            }
            if (this.invisibleAnnotations != null) {
                for (AnnotationData annotationData : this.invisibleAnnotations) {
                    annotationData.print(this.out, initialTab);
                    this.out.println();
                }
            }
            if (this.visibleTypeAnnotations != null) {
                for (TypeAnnotationData typeAnnotationData : this.visibleTypeAnnotations) {
                    typeAnnotationData.print(this.out, initialTab);
                    this.out.println();
                }
            }
            if (this.invisibleTypeAnnotations != null) {
                for (TypeAnnotationData typeAnnotationData : this.invisibleTypeAnnotations) {
                    typeAnnotationData.print(this.out, initialTab);
                    this.out.println();
                }
            }
        }
    }

    protected void printVar(StringBuilder bodyPrefix, StringBuilder tailPrefix, int name_cpx, int type_cpx) {
        if (this.pr_cpx) {
            bodyPrefix.append('#').append(name_cpx).append(":#").append(type_cpx);
            tailPrefix.append(";\t // ").append(this.cls.pool.getName(name_cpx)).append(':').append(this.cls.pool.getName(type_cpx));
        } else {
            bodyPrefix.append(this.cls.pool.getName(name_cpx)).append(':').append(this.cls.pool.getName(type_cpx));
            tailPrefix.append(';');
        }
        if (this.signature != null) {
            this.signature.print(bodyPrefix.append(':').toString(), tailPrefix.append(this.pr_cpx ? ":" : "").toString());
        } else {
            this.out.print(bodyPrefix);
            this.out.print(tailPrefix);
        }
        this.out.println();
    }

    protected void readAttributes(DataInputStream in) throws IOException {
        int natt = in.readUnsignedShort();
        this.attrs = new ArrayList(natt);
        TraceUtils.traceln(String.format("%s - Attributes[%d]", this.memberType, natt));
        block6: for (int k = 0; k < natt; ++k) {
            int name_cpx = in.readUnsignedShort();
            AttrData attr = new AttrData(this.cls);
            this.attrs.add(attr);
            String attr_name = this.cls.pool.getString(name_cpx);
            TraceUtils.traceln(String.format("   #%d name[%d]=\"%s\"", k, name_cpx, attr_name));
            Tables.AttrTag tag = Tables.attrtag(attr_name);
            int attrlen = in.readInt();
            switch (tag) {
                case ATT_Synthetic: {
                    if (attrlen != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isSynthetic = true;
                    continue block6;
                }
                case ATT_Deprecated: {
                    if (attrlen != 0) {
                        throw new ClassFormatError("invalid Deprecated attr length");
                    }
                    this.isDeprecated = true;
                    continue block6;
                }
                case ATT_RuntimeVisibleAnnotations: 
                case ATT_RuntimeInvisibleAnnotations: {
                    int cnt = in.readShort();
                    ArrayList<AnnotationData> annots = new ArrayList<AnnotationData>(cnt);
                    boolean invisible = tag == Tables.AttrTag.ATT_RuntimeInvisibleAnnotations;
                    for (int i = 0; i < cnt; ++i) {
                        TraceUtils.traceln("      AnnotationData: #" + i);
                        AnnotationData annot = new AnnotationData(invisible, this.cls);
                        annot.read(in);
                        annots.add(annot);
                    }
                    if (invisible) {
                        this.invisibleAnnotations = annots;
                        continue block6;
                    }
                    this.visibleAnnotations = annots;
                    continue block6;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    int tcnt = in.readShort();
                    ArrayList<TypeAnnotationData> tannots = new ArrayList<TypeAnnotationData>(tcnt);
                    boolean tinvisible = tag == Tables.AttrTag.ATT_RuntimeInvisibleTypeAnnotations;
                    for (int tindex = 0; tindex < tcnt; ++tindex) {
                        TraceUtils.traceln("      TypeAnnotationData: #" + tindex);
                        TypeAnnotationData tannot = new TypeAnnotationData(tinvisible, this.cls);
                        tannot.read(in);
                        tannots.add(tannot);
                    }
                    if (tinvisible) {
                        this.invisibleTypeAnnotations = tannots;
                        continue block6;
                    }
                    this.visibleTypeAnnotations = tannots;
                    continue block6;
                }
                default: {
                    boolean handled = this.handleAttributes(in, tag, attrlen);
                    if (handled) continue block6;
                    attr.read(name_cpx, attrlen, in);
                }
            }
        }
    }
}

